#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# _static/DBdriver.py
#
# DESCRIPTION:
# Virtual database driver for a connectionless, static set of data
#
# NOTES:
# Used whenever a fixed set of data is needed
#

__all__ = ['STATIC_RecordSet']

from gnue.common.apps import GDebug
import string
from gnue.common.datasources.GDataObjects import *


class STATIC_RecordSet (RecordSet): 

  def isPending(self):
    return 0

  # Post any changes to database
  def _postChanges(self): 
    return 1

  


