#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# SQLitedb/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via SQLite's Python Driver.
# Requires PySQLite (http://pysqlite.sf.net/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     dbname=    This is the SQLite database to use (required)
#


from string import lower,find,rfind,split,strip
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

raise "This data driver has not been upgraded to the new format."


try:
  import sqlite as SIG2api
except ImportError, message:
  tmsg = _("Driver not installed: SQLitedbapi for SQLite 7.x \n[%s]") % message
  raise GConnections.AdapterNotInstalled, tmsg


class SQLite_RecordSet(DBSIG2.RecordSet):
  pass


class SQLite_ResultSet(DBSIG2.ResultSet):
  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    DBSIG2.ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    self._recordSetClass = SQLite_RecordSet



class SQLite_DataObject(DBSIG2.DataObject):
  def __init__(self):
    DBSIG2.DataObject.__init__(self)
    self._DatabaseError = SIG2api.DatabaseError
    self._resultSetClass = SQLite_ResultSet


  def connect(self, connectData={}):
    GDebug.printMesg(1,"SQLite database driver initializing")
    try:
      self._dataConnection = SIG2api.connect(  \
                   db=connectData['dbname'], \
                   mode=077 )
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._postConnect()

  def _postConnect(self):
    self.triggerExtensions = TriggerExtensions(self._dataConnection)


  # Return a list of necessary login fields (e.g., user/pass).
  # Each list item is another list of ["field label", isPassword?]
  def getLoginFields(self):
    return []

  #
  # Schema (metadata) functions
  #

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('view',_('Views'),1),
            ('table',_('Table'),1)]

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    
    if type!=None:
      where=" WHERE type='%s'" % type
    else:
      where=""

    statement = "SELECT type,name,tbl_name,sql FROM sqlite_master "+\
                where+" UNION ALL "+\
                "SELECT type,name,tbl_name,sql FROM sqlite_temp_master "+\
                where+" ORDER BY name;"

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)    

    list = []
    for rs in cursor.fetchall():
      if rs[0] in ('table','view'):
        list.append(GDataObjects.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                               'type':rs[0],},
                                        getChildSchema=self.__getFieldSchema))

    cursor.close()
    print list
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    
    if type!=None:
      where=" AND type='%s'" % type
    else:
      where=""

    statement = ("SELECT type,name,tbl_name,sql FROM sqlite_master "+\
                 "WHERE name='%s'"+where+" UNION ALL "+\
                 "SELECT type,name,tbl_name,sql FROM sqlite_temp_master "+\
                 "WHERE name='%s' "+where+" ORDER BY name;") % (name,name)

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs and rs[0] in ('table','view'):
      schema = GDataObjects.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                          'type':rs[0],},
                                   getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema


  # Get fields for a table
  def __getFieldSchema(self, parent):

    if parent.type=='view':
      print "Views are not supported at the moment"
      return None

    statement = ("SELECT type,name,tbl_name,sql FROM sqlite_master "+\
                 "WHERE type='%s' and name='%s' UNION ALL "+\
                 "SELECT type,name,tbl_name,sql FROM sqlite_temp_master "+\
                 "WHERE type='%s' "+\
                 "and name='%s' ORDER BY name;") % (parent.type,parent.id,\
                                                    parent.type,parent.id)

    cursor = self._dataConnection.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)
    columns = cursor.description

    # Because sqlite don't store column definitions, but computes it
    # every time anew from the 'create table' statement, we have to
    # parse that statement to get the data

    # get sql definition of table
    rs = cursor.fetchone()
    cursor.close()
    if rs:
      sql=rs[3]
    else:
      return None

    # parse the sql definition
    GDebug.printMesg(3,"** Table definition: %s **" % sql)

    sql=sql[find(sql,'(')+1:rfind(sql,')')]
    fields = split(sql,',')
    list = []
    for field in fields:

      fls=split(strip(field),' ',2)

      if not fls[0] in ('Constraint','Primary'):
        
        try:
          nativetype= fls[1][:find(fls[1],'(')]

          size=int(fls[1][find(fls[1],'(')+1:-1])
        except:
          nativetype = fls[1]
          size=None
        
        attrs={'id': "%s.%s" % (parent.id, fls[0]), 'name': fls[0],
               'type':'field', 'nativetype': nativetype,
               'required':fls[2]=="NOT NULL"}
        
        if size!=None:
          attrs['length'] = size
        
        if nativetype in ('int','integer','bigint','mediumint',
                           'smallint','tinyint','float','real',
                           'double','decimal'):
          attrs['datatype']='number'
        elif nativetype[0] in ('date','time','timestamp','datetime'):
          attrs['datatype']='date'
        else:
          attrs['datatype']='text'

        list.append(GDataObjects.Schema(attrs=attrs))

    return list


class SQLite_DataObject_Object(SQLite_DataObject, \
      DBSIG2.DataObject_Object):

  def __init__(self):
    SQLite_DataObject.__init__(self)

  def _buildQuery(self, conditions={},forDetail=None,additionalSQL=""):
    return DBSIG2.DataObject_Object._buildQuery(self, conditions,forDetail, additionalSQL)


class SQLite_DataObject_SQL(SQLite_DataObject, \
      DBSIG2.DataObject_SQL):
  def __init__(self):
    # Call DBSIG init first because SQLite_DataObject needs to overwrite
    # some of its values
    DBSIG2.DataObject_SQL.__init__(self)
    SQLite_DataObject.__init__(self)

  def _buildQuery(self, conditions={}):
    return DBSIG2.DataObject_SQL._buildQuery(self, conditions)



#
#  Extensions to Trigger Namespaces
#
class TriggerExtensions:

  def __init__(self, connection):
    self.__connection = connection





######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'object': SQLite_DataObject_Object,
  'sql':    SQLite_DataObject_SQL
}

