#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# AsyncSocketServer
#
# DESCRIPTION:
# Set of classes that implement a Async(select)-based socket server.
#
# NOTES:
# These socket servers do their magic without threads or forking.
# Pretty cool, eh?
#

from gnue.common.rpc.drivers import Base

import asyncore
import asynchat
import socket
import string

from gnue.common.apps import GDebug


class AsyncSocketServer(Base.Server):

  def __init__(self, bindings, params):
    Base.Server.__init__(self, bindings, params)

    # TODO: This should probably allow you to connect
    # TODO: to both a Unix-style socket file and to a
    # TODO: TCP/IP socket simultaneously.

    try:
      self._socketfile = params['socket']
      if not len(self.__socketfile):
        raise ImportError
    except ImportError:
      self._socketfile = None
      self._port = params['port']

    # Create our dispatcher
    if self._socketfile:
      self._dispatcher = _AsyncUnixDispatcher(self, self._socketfile)
    else:
      # TODO: This only binds to 127.0.0.1...
      # TODO: Recode to allow the interface to be specified
      self._dispatcher = _AsyncInetDispatcher(self, ('',self._port))


  # Called by GComm when all is initialized
  # as we can start our infinite wait loop.
  def serve(self):
    asyncore.loop()


  # Called by the child socket listener to set
  def setChannelHandler(self, handler):
    self._dispatcher.setChannelHandler(handler)


class AsyncHTTPServer(AsyncSocketServer):
  pass



#
#
#
class AsyncChannel(asynchat.async_chat):
  def __init__(self, root, addr):
    self.root = root
    self.addr = addr
    asynchat.async_chat.__init__ (self, conn)




##############################################################################
#
# Internal classes
#
##############################################################################


#
# Socket Dispatcher
#
# Do not use this class... instead use
# _AsyncInetDispatcher or _AsyncUnixDispatcher
#
class _AsyncDispatcher(asyncore.dispatcher):

  def __init__(self, root, address):
    self.listen (128)
    self.root = root
    self._channel = AsyncChannel


  def handle_accept (self):
    conn, addr = self.accept()
    self._channel (self.root, conn, addr)

  def setChannelHandler(self, handler):
    self._channel = handler

#
# Bind to a port and dispatch events
#
class _AsyncInetDispatcher(_AsyncDispatcher):

  def __init__ (self, root, address):
    _AsyncDispatcher.__init__(self, root, address)
    self.create_socket (socket.AF_INET, socket.SOCK_STREAM)
    self.set_reuse_addr()
    self.bind (address)


#
# Bind to a UNIX-style socket file and dispatch events
#
class _AsyncUnixDispatcher(_AsyncDispatcher):

  def __init__ (self, root, file):
    self.create_socket (socket.AF_UNIX, socket.SOCK_STREAM)
    self.set_reuse_addr()
    self.bind (address)
    self.listen (128)
    self.root = root


