#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Dialog.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
import sio
from utility import _paintBorder
from Container import Container

class Frame(Container):
  """
    like a full screen container, but only a smaller portion of it.
    the user defines a screen region which makes up the frame...
    they may only put controls within this region.
  """
  def __init__(self, ParentContainer, y=0, x=0, h=2, w=2, caption="",
                border=1, dropshadow=1, **properties):
    SIOInstance = sio.sio()

    Container.__init__(self, **properties)
    self.PARENT = ParentContainer
    self.PARENT.AddFrame(self)
    self.VISIBLE = 0
    self.scrnbuff = {}
    self.Controls = []
    self.SCREEN = SIOInstance
    self.STARTPOINT = 0
    self.DIALOGWINDOW = None
    self.CAPTION = caption
    self.R1 = r1 = y
    self.R2 = r2 = y + h - 1
    self.C1 = c1 = x
    self.C2 = c2 = x + w - 1
    self._ChildOffsetX = border
    self._ChildOffsetY = border
    self.DROPSHADOW = dropshadow
    self.BORDER = border

    # need to add some sanity checks for bad params here:
    #if r1 > 0 and r1 <= SIOInstance.MAXROW:
    self.Y = r1
    #else:
    #  self.Y = 0
    #if c1 > 0 and c1 <= SIOInstance.MAXCOL:
    self.X = c1
    #else:
    #  self.X = 0

    self._DialogWidth = c2 - c1
    self._DialogHeight = r2 - r1
    self.INSET = 0
    self.buffer = self.Screen().CaptureScreen(self.R1,
        self.C1, self.R2 + dropshadow + border*2, self.C2 + dropshadow + border*2)
    self.SetColor('DIALOG')

  def __del__(self):
     pass

  def Show(self):
    return self.PARENT.RaiseFrame(self)

  def Hide(self):
    self.VISIBLE = 0
##    self.PARENT.Paint()

  def _PaintBorder(self):
    assert gDebug(2,'(!!!) PaintBorder')
    if not self.BORDER:
      return

    _paintBorder( self, self.Y,self.X, self._DialogHeight + 2,
      self._DialogWidth + 2, self.INSET, caption=self.CAPTION,
      color=self.SCREEN.colors.C_DIALOG,
      captionColor=self.SCREEN.colors.C_DIALOG_TITLE)

  def _PaintDropShadow(self):
    if not self.DROPSHADOW:
      return

    color = self.SCREEN.colors.C_DROPSHADOW

    self.SCREEN.PrintAt( self.R2 + self.BORDER*2, self.C1 + 1,
           (self._DialogWidth + self.BORDER*2) * " ", color)
    for i in range(1,self._DialogHeight + self.BORDER*2):
      self.SCREEN.PrintAt( self.R1 + i, self.C2 + self.BORDER*2, " ", color)


  def Paint(self, *args, **parms):
    if self.VISIBLE:
      if self.BORDER:
        self._PaintBorder()
      else:
        assert gDebug(0,'PAINTING %s' % self)

        for l in range(self._DialogHeight):
          self.SCREEN.PrintAt(self.Y+l, self.X, " " * self._DialogWidth, self.COLOR)
      self._PaintDropShadow()
      Container.Paint(self,*args, **parms)

  def Height(self):
    return self.R2- self.Y

  def Width(self):
    return self.C2- self.X


