#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# GFDesigner.py
#
# DESCRIPTION:
#
# NOTES:

import sys, os, string
from gnue.common.apps import RuntimeSettings

######################
#
# This is a debugging thing
#
import os, ihooks

class MyHooks(ihooks.Hooks):
  pass

_import_indent = 0

import __builtin__
__builtin__.__dict__['StartupStatus'] = lambda string:string

class MyModuleLoader(ihooks.ModuleLoader):

  def load_module(self, name, stuff):

    global _import_indent
    print "." * _import_indent + "Importing %s..." % name
    _import_indent += 1

    module = ihooks.ModuleLoader.load_module(self, name, stuff)

    _import_indent -= 1
    return module


if os.environ.has_key('GNUE_DEBUG_IMPORT'):
  ihooks.ModuleImporter(MyModuleLoader(MyHooks())).install()

######################

from StringIO import StringIO
from wxPython.wx import *
from gnue.common.apps.GClientApp import GClientApp
from gnue.common.apps import GDebug
from gnue.common.utils.FileUtils import dyn_import
from gnue.designer import VERSION, PACKAGE
from base.ModuleSupport import SupportedModules
from base import TemplateParser, TemplateChooser, MRUManager
from gnue.forms.GFConfig import ConfigOptions
from base.Config import ConfigOptions as DesignerConfigOptions

import time

from gnue.forms.uidrivers.wx import UILoginHandler #  import UIdriver as UIwxpython


class Designer(GClientApp, wxApp):

  # GClientApp stuff...
  NAME = PACKAGE
  VERSION = VERSION
  COMMAND = "gnue-designer"
  SUMMARY = _("A graphical tool for the rapid deployment of GNU Enterprise forms and reports.")
  COMMAND_OPTIONS = [
      [ 'new', 'n', 'new', 1, None, 'module',
          _('Starts up opening a new instance of <module>, where module can be forms, reports, schema, etc.') ],
      ]
  USAGE = GClientApp.USAGE + " [file] [file] ..."
  USE_DATABASE_OPTIONS = 1

  def __init__(self):
    GClientApp.__init__(self, application="forms",defaults=ConfigOptions)
    self.mru = MRUManager.MRUManager(self)
    self._instances = []

    self.configurationManager.loadApplicationConfig(section="designer",defaults=DesignerConfigOptions)
    self.configurationManager.registerAlias('gConfigNav', 'navigator')
    self.configurationManager.registerAlias('gConfigForms', 'forms')
    self.configurationManager.registerAlias('gConfigReports', 'reports')

    self.getConnectionManager().setLoginHandler(UILoginHandler())
    self.loadModuleInformation()

    wxApp.__init__(self,0)


  def run(self):
    self.MainLoop()

  def OnInit(self):
    wxInitAllImageHandlers()

    # Init the splashscreen
    from base.startup import Startup
    self.startup = Startup()
    StartupStatus(_('Initializing Client Library'))

    if len(self.ARGUMENTS):
      for arg in self.ARGUMENTS:
        self.SetTopWindow(self.load(arg))
    elif self.OPTIONS['new']:
      try:
        self.SetTopWindow(self.newInstance(self.OPTIONS['new']))
      except ImportError:
        raise
        self.handleStartupError('"%s" is not a valid option for --new' % self.OPTIONS['new'])

    else:

      # TODO: What to do when no object is specified on command line?
      # TODO: jcater thinks of some task selector like kword uses,
      # TODO: or, restore the session to the way it was (same files, etc)

      self.SetTopWindow(self.newInstance('forms'))

    self.startup.pauseAndClose()
    return 1


  def addInstance(self, instance):
    self._instances.append(instance)
    instance.registerEventListeners({
                       # Proxy for the main app
                       'RequestNew'          : self.OnNew,
                       'RequestSaveAll'      : self.OnSaveAll,
                       'RequestAbout'        : self.OnAbout,
                       'RequestNewWizard'    : self.OnWizard,
                       'RequestOpen'         : self.OnOpen,
                       'RequestOpenRecent'   : self.OnOpenRecent,
                       'RequestExit'         : self.OnExit
                    })




  def removeInstance(self, instance):
    self._instances.remove(instance)
    #for i in range(0, len(self._instances)):
    #  if self._instances[i] == instance:
    #    self._instances.pop(i)
    #    break

  # Do we have unsaved files?
  def isDirty(self):
    isdirty = 0
    for instance in self._instances:
      if instance.isDirty():
        isdirty = 1
        break
    return isdirty


  def OnWizard(self, event):

    wizard = TemplateChooser.TemplateChooser(self).run()
    if wizard != None:
      self.RunWizard(wizard)


  def RunWizard(self, templateInformation):

    product = templateInformation['Product']
    templateSupport = dyn_import('gnue.designer.%s.TemplateSupport' % product)

    try:
      style = templateInformation['ProductStyle']
    except:
      style = None

    instance = self.newInstance(product, style=style)

    if not TemplateParser.TemplateParser(instance, instance.rootObject,
          instance, templateInformation).run():
      instance.Close()


  def isFileOpened(self, location):
    # TODO: Check to see if a file is already opened
    return 0

  def OnOpen(self, event):

    dlg = wxFileDialog(NULL, _("Open GNUe File..."), defaultDir=os.getcwd(),
                           wildcard = self.supportedOpenWildcard,
                           style=wxOPEN)

    if dlg.ShowModal() == wxID_OK:
      if self.isFileOpened(dlg.GetPath()):
        # TODO: Um, something better than this!!!
        print "File is already opened!"
      else:
        self.load(dlg.GetPath())

    dlg.Destroy()


  def OnOpenRecent(self, event):

    location = self.mru.mruMenuMap[event.GetId()]
    if not self.isFileOpened(location):
      self.load(location )


  def OnExit(self, event=None):

##     if self.isDirty():
##       dlg = wxMessageDialog(NULL,
##               _("There are open documents with unsaved changes.\n")+
##               _("Exit anyway?"),
##               _("Unsaved Changes"), style=wxYES_NO|wxICON_WARNING)
##       save = dlg.ShowModal()
##       dlg.Destroy()
##       if save == wxID_NO:
##        return

    for instance in self._instances[:]:
      instance.Close()
      #
      # If this Close() causes issues you can replace
      # with the following.
      #
      #RuntimeSettings.saveRuntimeSettings(instance)
      #instance.Destroy()

  def OnSaveAll(self, event):
    for instance in self._instances:
      if instance.isDirty():
        instance.OnSave(event)

  def OnAbout(self, event):
    imports = []
    for f in ('common','forms','reports','appserver','navigator'):
      try:
        v = {}
        exec 'from gnue.%s import __version__, PACKAGE' % f in v
        imports.append('%s Version %s' % (v['PACKAGE'], v['__version__']))
      except:
        pass

    from wxPython import __version__ as v
    imports.append('wxPython Version %s' % v)

    from sys import version as v
    imports.append('Python Version %s' % v.replace('\n','\n    '))


    dlg = wxMessageDialog(NULL, self.NAME + " " +
                                _("Version  ") + self.VERSION + "\n\n" +
                                _("Copyright 2001-2004 Free Software Foundation\n\n") +
                                _("Environment:\n  %s\n\n") % string.join(imports,'\n  ') +
                                _("For help, email info@gnue.org."),
                                _("About ") + self.NAME, style=wxOK|wxICON_INFORMATION)
    dlg.ShowModal()
    dlg.Destroy()



  def loadModuleInformation(self):

    StartupStatus(_('Loading available tool modules'))

    self.supportedModuleObjects = []
    self.supportedOpenWildcard = ""
    self.moduleExtensionMapping = {}


    wildcard = ""
    alltypes = []


    # TODO: wxWidgets currently doesn't consistently support multiple file
    # TODO: extension wildcards (e.g., "All GNUe Form Files (*.gfd,*.gfl)").
    # TODO: However, the code is left commented out in case some day it does.

    for module in SupportedModules:
      self.supportedModuleObjects.append((module.properties.nickname, module))


    ##  if len(module.properties.fileExtensions.keys()) > 1:
    ##
    ##    wildcard += "%s Files (*.%s)|*.%s|" % \
    ##             ( module.properties.application,
    ##               string.join(module.properties.fileExtensions.keys(),',*.'),
    ##               string.join(module.properties.fileExtensions.keys(),';*.') )


      # Make the "default" file extension for a module
      # appear before the other extensions.
      wildcard += "%s (*.%s)|*.%s|" % \
       ( module.properties.fileExtensions[module.properties.defaultFileExtension],
         module.properties.defaultFileExtension,
         module.properties.defaultFileExtension)

      for type in module.properties.fileExtensions.keys():
        if type != module.properties.defaultFileExtension:
          wildcard += "%s (*.%s)|*.%s|" % \
             ( module.properties.fileExtensions[type], type, type)
        alltypes.append(type)

        # Keep a dict of Extension::Handler mappings
        self.moduleExtensionMapping[type] = module.properties.module



    ##  self.supportedOpenWildcard = "All Supported Files (*.%s)|*.%s|" % \
    ##              ( string.join(alltypes,',*.'),
    ##              string.join(alltypes,';*.') ) \
    ##            + wildcard \
    ##            + "All Files (*.*)|*.*"
      self.supportedOpenWildcard = wildcard \
                                 + "All Files (*.*)|*.*"


  #
  # Load a new object from file
  #
  def load(self, file):

    StartupStatus(_('Loading document'))

    extension = string.lower(os.path.splitext(file)[1][1:])

    if not self.moduleExtensionMapping.has_key(extension):

      # TODO: This should try to figure out what kind of file this is.
      # TODO: We maintain a list of opening xml elements in the
      # TODO: (gnue.designer.SupportedModules).properties object.
      # TODO: [gnue.designer.SupportedModules is a list]

      print "I do not know what to do with a .%s file!" % extension
      return None

    return self.newInstance(self.moduleExtensionMapping[extension], file)


  def OnNew(self, event):
    self.newInstance(event.type)


  #
  # Create a new instance
  #
  def newInstance(self, module, *args, **parms):
    c = dyn_import("gnue.designer.%s.Instance" % module).Instance
    return c(self, *args, **parms)


#
# Workaround for Python 2.2's big unicode bug!!!
# TODO: I don't think this is working!
# TODO: Pop up a warning dialog
#
if sys.version[:5] == "2.2.0":
  from cStringIO import StringIO


#
#
#
if __name__ == '__main__':
  Designer().run()

