#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# Tools.py
#
# DESCRIPTION:
# Base class for all Tool panels
#
# NOTES:
#

__all__ = ['ToolBase']

from wxPython.wx import *
from gnue.common.apps import RuntimeSettings
from gnue.common import events


class ToolBase (wxPanel, events.EventAware):

  default_visible = 1
  default_dock = 'frame'
  runtime_section = ""
  uses_feedback_bar = 0
  uses_toolbar = 0

  def __init__(self, id, title, instance, rootObject, parentWindow):
    wxPanel.__init__(self,parentWindow,-1)
    events.EventAware.__init__(self, instance)

    self.id = id
    self.title = title
    self.dockpane = parentWindow
    self.instance = instance
    self.rootObject = rootObject
    self.instance.globalAcceleratorListeners.append(self)

    self.init()
    instance.registerEventListeners({'Show:Tool:%s' % id: self.__show,
                                     'Hide:Tool:%s' % id: self.__hide})

    RuntimeSettings.registerRuntimeSettingHandler(self.instance, self)

  def saveRuntimeSettings(self):
    return (self.runtime_section, {})

  def setFeedback(self, text):
    self.dockpane.setFeedback(text)

  def __show(self, event):
    self._visible = 1
    self.dockpane.show()


  def __hide(self, event):
    self._visible = 0
    self.dockpane.hide()


