#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# ToolPanel.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['DockedPane']

from wxPython.wx import *

TITLEBAR_ACTIVE = wxSystemSettings_GetSystemColour(wxSYS_COLOUR_HIGHLIGHT)
TITLETEXT_ACTIVE = wxSystemSettings_GetSystemColour(wxSYS_COLOUR_HIGHLIGHTTEXT)
#TITLEBAR_INACTIVE = wxSystemSettings_GetSystemColour(wxSYS_COLOUR_BTNFACE)
#TITLETEXT_INACTIVE = wxSystemSettings_GetSystemColour(wxSYS_COLOUR_BTNFACE)

from BasePane import BasePane

#
#
#
class DockedPane(wxSashWindow, BasePane):
  def __init__(self, parent, instance, tool):
    wxSashWindow.__init__(self, parent, -1, style=wxSW_3DSASH|wxCLIP_CHILDREN)
    BasePane.__init__(self, parent, instance, tool)
    # These are used exclusively by ToolDock

    self.statusbar = instance.statusbar
    self.minimumVerticalSize = 0
    self.lastSize = 0

    self.statusbar = None
    EVT_SIZE(self, self.__OnSize)
    EVT_SASH_DRAGGED(self, self.GetId(), self.__OnDrag)

    self.sizer = sizer = wxBoxSizer(wxVERTICAL)

    if sys.platform == "win32":
      size = (1, 16)
    else:
      size = (-1,-1)

    tp = self.__titlePanel = wxPanel(self,-1, wxPoint(0,0), size)#, style=wxSIMPLE_BORDER)
    tp.SetBackgroundColour(TITLEBAR_ACTIVE)
    sizer.Add(tp,0, wxALL|wxEXPAND, border=2)

    tt = self.__titleText = wxStaticText(tp,-1,tool.title,wxPoint(4,1))
    tt.SetForegroundColour(TITLETEXT_ACTIVE)
    font = tt.GetFont()
    font.SetWeight(wxBOLD)
    tt.SetFont(font)
    x, y = tt.GetSizeTuple()

    tp.SetClientSize((tp.GetClientSizeTuple()[0], y+3))
    self.minimumVerticalSize = y + 3

    EVT_LEFT_DCLICK(tp, self.__LeftDClick)
    EVT_LEFT_DCLICK(tt, self.__LeftDClick)

    EVT_RIGHT_UP(tp, self.__RightClick)
    EVT_RIGHT_UP(tt, self.__RightClick)

    if tool.uses_toolbar:
      sizer.Add(tool.createToolbar(self), 0, wxEXPAND)

    sizer.Add(tool, 1, wxEXPAND)
    self.SetAutoLayout(true)
    self.SetSizer(sizer)
    self.Layout()

  def __LeftDClick(self, event):
    self.parent.toggleMinimized(self)

  def __RightClick(self, event):
    # Display a menu
    menu = wxMenu()

    nid = wxNewId()
    menu.Append(nid, _("Hide Tool"))
    EVT_MENU(self, nid, self.__Hide)
    if self.tool._visible:
      menu.Enable(nid, 0)

    nid = wxNewId()
    menu.Append(nid, _("Show Tool"))
    EVT_MENU(self, nid, self.__Restore)
    if not self.tool._visible:
      menu.Enable(nid, 0)

    menu.AppendSeparator()

    nid = wxNewId()
    menu.Append(nid, _("Release to Frame"))
    EVT_MENU(self, nid, self.__BreakAway)
##    menu.Enable(nid, 0)  # TODO

    self.PopupMenu(menu, event.GetPosition())

  # Called by GNUe's event dispatcher
  def hide(self):
    self.parent.minimize(self)

  # Called by GNUe's event dispatcher
  def show(self):
    self.parent.restore(self)

  # Called by the popup menu when user right-clicks
  def __Hide(self, event):
    self.instance.dispatchEvent('Hide:Tool:%s' % self.tool.id)

  # Called by the popup menu when user right-clicks
  def __Restore(self, event):
    self.instance.dispatchEvent('Show:Tool:%s' % self.tool.id)

  # Called by the popup menu when user right-clicks
  def __BreakAway(self, event):
    self.instance.dispatchEvent('Docker:Undock', tool=self.tool)

  def __OnSize(self, event):
    if self.GetAutoLayout():
      self.Layout()

  def __OnDrag(self, event):
    newHeight = event.GetDragRect().height
    self.parent.resize(self, newHeight)

  def setFeedback(self, text):
    self.instance.statusbar.SetStatusText(text)
