#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# ReorderFocus.py
#
# DESCRIPTION:
#
# NOTES:
#

import sys, string
from gnue.common.apps import GDebug
from WidgetFocusTab import WidgetFocusTab
#
#
#
class ReorderFocus:
  def __init__(self, instance):
    self.instance = instance

  def start(self, page):
    self.list = []
    self.page = page
    self.page.walk(self._buildList)

    i = 0
    for tab in self.list:
      tab.setOrder(i)
      i += 1

  def _buildList(self, object):
    # TODO: More intelligence
    # TODO: allow only cycling thru current block, selection, or page
    if object._type in ('GFEntry','GFButton') and hasattr(object,'_widgetHandler'):
      self.list.append(WidgetFocusTab(self.instance, object))

  def end(self):
    for object in self.list:
      object.close()
    self.list = []

