#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# schema/wizards/WriteSchema.py
#
# DESCRIPTION:
# Store Schema into a Database
#

from gnue.designer.base.TemplateBase import *
from gnue.designer import VERSION
#from gnue.common
import string


class WriteSchemaWizard(TemplateBase):


  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.schema = root
    self.current = current


  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, step):

    # 0 - Get Connection
    # 1 - Choose the tables which should be writte (todo)
    # 2 - Show conflicts and ask how to solve them (todo)

    #
    # Step #1 / Get Connection
    #
    if step == '0':
      return   { 'title': 'Choose Database Connection',
                 'content': (WizardText('Welcome to the sample form wizard.'),
                             WizardText('To what connection should this schema be written?'),
                             WizardInput('connection',label='Connection:', required=1,
                                         set=self.GetAvailableConnections()),
                             WizardText('You may be asked to login to this connection.'),
                            ),
                 'prev': None,
                 'next': None }



  ###############
  #
  # Verify contents of current step
  # Return None if no problems, otherwise
  # return a tuple of error message strings
  #
  def ValidateStep(self, stepCode):

    # The Simple wizard uses basic "required"
    # settings in the page markup, so doesn't
    # need any special validation.
    return None



  ###############
  #
  # We have all the data, so generate our form. This
  # is called after the user clicks the "Finish" button.
  # No more user input is allowed at this point.
  #
  def Finalize(self):

    con=self.GetTemporaryConnection(self.variables['connection'])

    con.writeSchema(self.schema,0)

    return 1



############
#
# Basic information about this template
#

### The ZZZ disables this from showing up temporarily

ZZZ_TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'WriteSchema',
    'BaseClass' : WriteSchemaWizard,
    'Name' : 'Write Schema Definition',
    'Description' : 'write a gnue schema definition to the database',
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : ('Extras',_('Write Schema to Database'))
}

