#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# TreeView.py
#
# DESCRIPTION:
# The TreeView for forms instances
#
# NOTES:
#
# TODO: all the SetItemImage lines in this file have been
# TODO: commented out as on win32 it was segfaulting
#

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.logic import GTrigger
from gnue.common.datasources import GDataSource
from gnue.forms import GFForm, GFObjects, GFLibrary
from gnue.designer.base.PopupMenu import ObjectMenu
from gnue.designer.base.Icons import treeIconMap, treeIconList
from gnue.designer.base.tools.TreeView import TreeView as BaseTreeView

class TreeView (BaseTreeView):

  rootDescr = 'Form'

  def inittree(self):

    logic = None
    layout = None
    for child in self.rootObject._children:
      if child._type == 'GFLogic':
        logic = child
      elif child._type == 'GFLayout':
        layout = child

    self.rootObject._treeItemFormProperties = \
        self.AppendItem(self.rootObject._treeItem, _("Properties"))
    self.tree.SetItemImage(self.rootObject._treeItemFormProperties, treeIconMap['properties'])
    self.rootObject._treeItemImportedLibraries = \
        self.AppendItem(self.rootObject._treeItem, _("Imported Libraries"))
    self.tree.SetItemImage(self.rootObject._treeItemImportedLibraries, treeIconMap['import'])
    self.rootObject._treeItemDataSources = \
        self.AppendItem(self.rootObject._treeItem, _("Data Sources"))
    self.tree.SetItemImage(self.rootObject._treeItemDataSources, treeIconMap['datasource'])
    self.rootObject._treeItemNamedTriggers = \
        self.AppendItem(self.rootObject._treeItem, _("Shared Triggers"))
    self.tree.SetItemImage(self.rootObject._treeItemNamedTriggers, treeIconMap['trigger'])
    self.rootObject._treeItemLogic = logic._treeItem = \
        self.AppendItem(self.rootObject._treeItem, _("Field Logic"))
    self.tree.SetItemImage(self.rootObject._treeItemLogic, treeIconMap['block'])
    self.rootObject._treeItemPageLayout = layout._treeItem = \
        self.AppendItem(self.rootObject._treeItem, _("Page Layout"))
    self.tree.SetItemImage(self.rootObject._treeItemPageLayout, treeIconMap['page'])

    self.tree.SetPyData(self.rootObject._treeItemFormProperties, ObjectMenu(self.instance,None))
    self.tree.SetPyData(self.rootObject._treeItemDataSources, ObjectMenu(self.instance,None))
    self.tree.SetPyData(self.rootObject._treeItemNamedTriggers, ObjectMenu(self.instance,None))
    self.tree.SetPyData(self.rootObject._treeItemLogic, logic)
    self.tree.SetPyData(self.rootObject._treeItemPageLayout, layout)


  def inventoryObject (self, object):
    if object != self.rootObject:
      icon = 'properties'
      if isinstance(object, GFObjects.GFOptions) and \
         object._parent == self.rootObject:
        object._treeItem = self.rootObject._treeItemFormProperties
        icon = 'properties'
      elif object._type in ('GFLogic','GFLayout') and \
           object._parent == self.rootObject:
        pass
      else:
        parentTreeItem = object._parent._treeItem
        if isinstance(object, GTrigger.GTrigger) and \
           object.type == 'NAMED':
          parentTreeItem = self.rootObject._treeItemNamedTriggers
          icon = 'trigger'
        elif isinstance(object, GTrigger.GTrigger):

          if not hasattr(object._parent,'_treeItemTrigger'):
            object._parent._treeItemTrigger = \
              self.AppendItem(object._parent._treeItem, _("Events"))
            #self.tree.SetItemImage(object._parent._treeItemTrigger, treeIconMap['trigger'])


          parentTreeItem = object._parent._treeItemTrigger
          icon = 'trigger'
        elif isinstance(object, GFObjects.GFDataSource) or \
           isinstance(object, GDataSource.GConnection):
          parentTreeItem = self.rootObject._treeItemDataSources
          icon = 'datasource'
        elif isinstance(object, GFObjects.GFPage) and \
             object._parent == self.rootObject:
          icon = 'page'
        elif object._type in ('GFBlock',):
          icon = 'block'
        elif object._type in ('GFOption',):
          icon = 'properties'
        elif object._type in ('GFEntry',):
          icon = 'entry'
        elif len(object._type) >= 8 and \
             object._type[:8] == 'GFImport':
          icon = 'import'
        elif object.findParentOfType('GFPage') != None:
          icon = 'pagewidget'


        object._treeItem = self.AppendItem(parentTreeItem,
            "%s" % object.getDescription())
        self.tree.SetPyData(object._treeItem, object)
        #self.tree.SetItemImage(object._treeItem, treeIconMap[icon])


