#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# wx/Instance.py
#
# DESCRIPTION:
"""
Instance class for wxWidgets
"""
# NOTES:
#

from wxPython.wx import *
from gnue.designer.base import Goat
from gnue.common.apps import RuntimeSettings
from docks.Docker import Docker
from gnue.designer import PACKAGE as TITLE

from gnue.designer.base.PrimaryToolBar import PrimaryToolBar

from MenuBar import MenuBar

class Instance(wxFrame):
  def __init__(self, instance):
    wxFrame.__init__(self, NULL, -1, "")
    self.instance = instance
    icon = Goat.getGoatIcon()
    self.SetIcon(icon)

    self.toolbar = PrimaryToolBar(self, self.instance)
    self.SetToolBar(self.toolbar)

    self.statusbar = self.CreateStatusBar()
    self.SetStatusText(_('Welcome to GNUe Designer -- Do not expose to direct sunlight, do not feed after midnight, and do not get wet.'))

    EVT_CLOSE(self, self.instance.OnClose)

  def createMenuBar(self):
    menuBar = MenuBar(self.instance)
    self.SetMenuBar(menuBar)
    return menuBar

  def setTitle(self, title):
    self.SetTitle(TITLE + " - " + title)

  def show(self):
    self.Show(True)

  def hide(self):
    self.Show(False)

  def finalize(self):
    # Build accelerator list
    accel = wxAcceleratorTable(self.instance.globalAccelerators)
    for child in [self] + self.instance.globalAcceleratorListeners:
      child.SetAcceleratorTable(accel)

    # Fit the widgets to the screen
    self.Fit()

    self.SetSize((
       RuntimeSettings.getint(self.instance.runtime_section, 'width', 550),
       RuntimeSettings.getint(self.instance.runtime_section, 'height', 400)))

    self.SetPosition((
       RuntimeSettings.getint(self.instance.runtime_section, 'x', -1),
       RuntimeSettings.getint(self.instance.runtime_section, 'y', -1)))

    self.Show(true)
    self.Refresh()

  def initTools(self):
    self.docker = Docker(self, self.instance, self.instance._toolCache)

  #
  #  Used by RuntimeSettings
  #
  def getRuntimeSettings(self):
    x, y = self.GetPositionTuple()
    width, height = self.GetSizeTuple()
    settings = { 'x': abs(x),
                 'y': abs(y),
                 'height': height,
                 'width': width  }

    return settings

  def close(self):
    self.Destroy()

  def setStatus(self, text):
    self.statusbar.SetStatusText(text)
