#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# Startup.py
#
# DESCRIPTION:
#
# NOTES:


from wxPython.wx import *
import sys, os
import __builtin__
from gnue.common.apps import GConfig

__builtin__.__dict__['gStartupStatus'] = lambda string:string

splashloc = os.path.join(GConfig.getInstalledBase('designer_images','common_images') ,'designer', 'splash.png')

class Startup(wxSplashScreen):
  def __init__(self):
    splashbitmap = wxImage(splashloc,
                   wxBITMAP_TYPE_PNG).ConvertToBitmap()

    __builtin__.__dict__['gStartupStatus'] = self.startupStatus
    wxSplashScreen.__init__(self, splashbitmap,
       wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_NO_TIMEOUT,400, None, -1,
       style=wxSIMPLE_BORDER|wxFRAME_NO_TASKBAR|wxSTAY_ON_TOP)
    self.text = 'Loading...'
    EVT_PAINT(self.GetSplashWindow(), self.OnPaint)
    EVT_CLOSE(self, self.destroy)
    self.timer = None

  def pauseAndClose(self):
    self.Raise()
    gStartupStatus('Finalizing Settings')
    MyTimer(self.setSettingsText).Start(100)
    self.timer = MyTimer(self.destroy).Start(1000)

  def setSettingsText(self):
    # Fscking, bastardized GTK piece of damn crap
    gStartupStatus('Finalizing Settings')

  def destroy(self, event=None):
    self.hide()
    self.Destroy()

  def hide(self, event=None):
    try:
      self.timer.Stop()
    except:
      pass
    self.timer = None
    __builtin__.__dict__['gStartupStatus'] = lambda string:string
    self.Show(0)

  def startupStatus(self, text):
    self.drawText(wxWHITE)
    self.text = "%s..." % text
    self.OnPaint()

  def drawText(self, color):
    # TODO: FIXME
    if sys.platform == "win32":
      print self.text
      return
    dc = wxPaintDC(self.GetSplashWindow())
    dc.SetTextForeground(color)
    dc.BeginDrawing()
##    font = wxFont(12, wxNORMAL, wxNORMAL, wxNORMAL)
##    dc.SetFont(font)
    dc.DrawText(self.text, 35, 225)
    dc.EndDrawing()

  def OnPaint(self, event=None):
    self.drawText(wxBLACK)
    if event:
      event.Skip()


class MyTimer(wxTimer):
    def __init__(self, method, *args, **params):
      self.__method = method
      self.__args = args
      self.__params = params
      wxTimer.__init__(self)

    def Notify(self):
      try:
        self.__method(*self.__args, **self.__params)
      except wxPyDeadObjectError:
        # WTF?!?!  Why isn't my .Stop() above working!!!!!
        self.Stop()

    def IsOneShot(self):
      return 1

