#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/button.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.forms.uidrivers.html.widgets._base import UIHelper, HtmlWidget
from gnue.forms.uidrivers.html.common import *


class UIButton(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object

    dhtml = '<input type="button" name="entGnueName" id="blkGnue_class_fldCGnueName_field" \
            style="position:absolute; top:%spx; left:%spx; width:%spx; height:%spx;\
            value="%s" />' % \
            (object.Char__y*event.widgetHeight + FIX,\
             object.Char__x*event.widgetWidth,\
             self.itemWidth,\
             self.itemHeight,\
             textEncode(object.label))

    newWidget = HtmlWidget(event.container, self._uiDriver, 'BUTTON', dhtml, getNextId())

    return newWidget

configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
