#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# qt/MenuBar.py
#
# DESCRIPTION:
"""
A generic UIdriver base for common message-based GUI toolkits.
"""
# NOTES:
#

import string
from qt import *
from gnue.forms.uidrivers._commonGuiToolkit.MenuBar import MenuBar as _BaseMenuBar

class MenuBar(_BaseMenuBar):

  # Create the menu
  def init(self):
    self.menu = self.container.menuBar()
    self.__idmap = {}
    return self.menu

  # Add a (sub)menu
  def addMenu(self, name, parent):
    menu = QPopupMenu(parent)
    parent.insertItem(name, menu)
    QObject.connect(menu, SIGNAL('activated(int)'), self.__itemSelected)

    return menu

  # Add a menu item (action)
  def addAction(self, name, parent, userAction):
    label = name
    hotkey = userAction.getHotKeyText()
    iconloc = userAction.getIconLocation(size="16x16")

    if hotkey:
      label += '\t%s' % hotkey

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = QIconSet(QPixmap(iconloc))
        _cachedIcons[iconloc] = icon
      id = parent.insertItem(icon, label)
    else:
      id = parent.insertItem(label)

    parent.setWhatsThis(id, userAction.description or '')

    self.__idmap[id] = 'request' + userAction.event

    return (parent, id)

  # Add a separator
  def addSeparator(self, parent):
    parent.insertSeparator()

  # Enable a menu item
  def enableItem(self, item):
    parent, id = item
    parent.setItemEnabled(id, 1)

  # Disable a menu item
  def disableItem(self, item):
    parent, id = item
    parent.setItemEnabled(id, 0)

  # A menu item was selected
  def __itemSelected(self, itemid):
    self.driver.dispatchEvent(self.__idmap[itemid], _form=self.form)


_cachedIcons = {}


