#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: box.py 6851 2005-01-03 20:59:28Z jcater $

from wxPython.wx import *

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import wxEncode

# =============================================================================
# Wrap an UI layer around a wxStaticBox widget
# =============================================================================
class UIBox(UIHelper):
  """
  Creates a single instance of a border box
  """

  # --------------------------------------------------------------------------
  # Create a staticbox widget
  # --------------------------------------------------------------------------
  def _createWidget(self, event, spacer):
    """
    Creates a new Static Box widget.
    """
    object = event.object

    itemX =      self.itemX + (event.widgetWidth / 2)
    itemY =      self.itemY + (event.widgetHeight / 2)
    itemWidth =  (object.Char__width - 1) * event.widgetWidth
    itemHeight = (object.Char__height - 1) * event.widgetHeight

    newWidget = wxStaticBox(event.container, -1, wxEncode(object.label),
                       wxPoint(itemX, itemY), wxSize(itemWidth, itemHeight))
    return newWidget


# ----------------------------------------------------------------------------
# Configuration data
# ----------------------------------------------------------------------------
configuration = {
    'baseClass'  : UIBox,
    'provides'   : 'GFBox',
    'container'  : 0,
    }
