# GNU Enterprise Forms - GTK UI Driver - common signal handler
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: common.py 7358 2005-04-12 19:44:17Z reinhard $

import gtk

from gnue.common import events
   

# -----------------------------------------------------------------------------
# Set all default event handlers for GTK widgets
# -----------------------------------------------------------------------------

def _setDefaultEventHandlers (newWidget, eventHandler, initialize, uiDriver,
                              lookup = None):
  if initialize:
    lookup = lookup is None and newWidget or lookup

    newWidget.connect ("key-press-event", _keyPressHandler, uiDriver,
                             eventHandler, lookup)
    gDebug (6, "Added key-press-event to %s" % newWidget)


# -----------------------------------------------------------------------------
# Key press handler
# -----------------------------------------------------------------------------

def _keyPressHandler (widget, event, uiDriver, eventHandler, lookup):

  gDebug (4, "Common-keypress: %s %s" % (event.type, event.keyval))

  if event.type != gtk.gdk.KEY_PRESS:
    return False

  action  = None
  keycode = event.keyval
  
  isShift = event.state & gtk.gdk.SHIFT_MASK   > 0
  isLock  = event.state & gtk.gdk.LOCK_MASK    > 0
  isCtrl  = event.state & gtk.gdk.CONTROL_MASK > 0
  isMod1  = event.state & gtk.gdk.MOD1_MASK    > 0

  if keycode == gtk.keysyms.ISO_Left_Tab:
    gDebug (6, "Mapping Shit-Tab to Tab")
    keycode = gtk.keysyms.Tab

  # Map the Enter-Key of the numeric block to the Return-Key
  if keycode == gtk.keysyms.KP_Enter:
    gDebug (6, "Mapping numeric Enter to Return")
    keycode = gtk.keysyms.Return

  if not uiDriver._WidgetToGFObj.has_key (lookup):
    gDebug (1, "can't find widget %s" % lookup)
    return False

  gfObject = uiDriver._WidgetToGFObj [lookup]

  # Get the event to process from the KeyMapper
  command = GFKeyMapper.KeyMapper.getEvent (keycode, isShift, isCtrl, isMod1)

  if command:
    action = events.Event ('request%s' % command)

    # Add the gfObject's _form to the outgoing event
    # rather than every event in the function
    gDebug (4, "Calling %s" % action.__event__)
    action.__dict__.update ({'_form': gfObject._form})
    eventHandler (action)
    return True
  else:
    gDebug (4, "Key dropped!")


#####################################################################
##
## Keymapper Support
##
#####################################################################

# TODO: Check if we can/want to take over global key maps (like gnome keymap)

from gnue.forms import GFKeyMapper
from gnue.forms.GFKeyMapper import vk

# Translate from wx keystrokes to our virtual keystrokes
gtkKeyTranslations = {
   vk.F1     : gtk.keysyms.F1,        vk.F2        : gtk.keysyms.F2,
   vk.F3     : gtk.keysyms.F3,        vk.F4        : gtk.keysyms.F4,
   vk.F5     : gtk.keysyms.F5,        vk.F6        : gtk.keysyms.F6,
   vk.F7     : gtk.keysyms.F7,        vk.F8        : gtk.keysyms.F8,
   vk.F9     : gtk.keysyms.F9,        vk.F10       : gtk.keysyms.F10,
   vk.F11    : gtk.keysyms.F11,       vk.F12       : gtk.keysyms.F12,
   vk.INSERT : gtk.keysyms.Insert,    vk.DELETE    : gtk.keysyms.Delete,
   vk.HOME   : gtk.keysyms.Home,      vk.END       : gtk.keysyms.End,
   vk.PAGEUP : gtk.keysyms.Prior,     vk.PAGEDOWN  : gtk.keysyms.Next,
   vk.UP     : gtk.keysyms.Up,        vk.DOWN      : gtk.keysyms.Down,
   vk.LEFT   : gtk.keysyms.Left,      vk.RIGHT     : gtk.keysyms.Right,
   vk.TAB    : gtk.keysyms.Tab,
   vk.ENTER  : gtk.keysyms.Return,    vk.BACKSPACE : gtk.keysyms.BackSpace }

GFKeyMapper.KeyMapper.setUIKeyMap (gtkKeyTranslations)
