# GNU Enterprise Forms - GTK UI Driver - Form widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: widget.py 7226 2005-03-19 18:14:42Z johannes $

import gtk
import string
import wrappers
import types

from gnue.common import events
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper
from gnue.forms.uidrivers.gtk2.MenuBar import MenuBar
from gnue.forms.uidrivers.gtk2.ToolBar import ToolBar


# =============================================================================
# This class creates a single instance of a form widget
# =============================================================================

class UIForm (UIHelper):
  
  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, event):
    self._uiPageList = []
    self.statusBar   = None

    UIHelper.__init__ (self, event)

  
  # ---------------------------------------------------------------------------
  # GTK-Widget creation
  # ---------------------------------------------------------------------------

  def _createWidget (self, event, spacer):

    gfObject = event.object

    self.menu_sb_space = 0

    formWidth  = int (self._form._layout.Char__width)
    formHeight = int (self._form._layout.Char__height)

    self._visibleSize = (formWidth  * self._uiDriver.widgetWidth,
                         formHeight * self._uiDriver.widgetHeight)
    
    self._formSize = formSize = (formWidth * self._uiDriver.widgetWidth,
               (formHeight + self.menu_sb_space) * self._uiDriver.widgetHeight)

    # The main frame of this form
    if self._form.style != 'dialog':
      self.mainWindow = gtk.Window ()
      self.mainWindow.set_resizable (True)
      self.content_table = gtk.Table (4, 1, False)
      self.mainWindow.add (self.content_table)

      self.containerFrame = gtk.Frame ()
      self.content_table.attach (self.containerFrame,
                 # X direction           Y direction
                 0, 1,                   2, 3,
                 gtk.EXPAND | gtk.FILL,  gtk.EXPAND | gtk.FILL,
                 0,                      0)
      self.containerFrame.show ()

    else:
      self.mainWindow = gtk.Dialog (flags = gtk.DIALOG_NO_SEPARATOR |
          gtk.DIALOG_DESTROY_WITH_PARENT)
      self.mainWindow.set_resizable (True)
      self.mainWindow.action_area.set_size_request (-1, 0)

      self.content_table = gtk.Table (4, 1, False)

      self.containerFrame = gtk.Frame ()
      self.content_table.attach (self.containerFrame,
                 # X direction           Y direction
                 0, 1,                   2, 3,
                 gtk.EXPAND | gtk.FILL,  gtk.EXPAND | gtk.FILL,
                 0,                      0)

      wx = (formWidth  + 1) * self._uiDriver.widgetWidth
      wy = (formHeight + 1) * self._uiDriver.widgetHeight

      self.containerFrame.set_size_request (wx, wy)

      self.mainWindow.vbox.pack_start (self.content_table)
      self.containerFrame.show ()
      self.content_table.show ()

    self.mainWindow.connect ('delete_event', self.windowExitEvent)
    self.accelGroup = gtk.AccelGroup ()
    self.mainWindow.add_accel_group (self.accelGroup)

    title = "%s" % self._form.title
    self.mainWindow.set_title (self._makeSafe (title))

    if gfObject._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper (self)
    else:
      self._wrapper = wrappers.PlainWrapper (self)

    newWidget = self._wrapper.pane
    self._containerToolkitWidget = newWidget
    
    # Add the menu
    if not self._form._features ['GUI:MENUBAR:SUPPRESS']:
      MenuBar (self._uiDriver, self, self._form)
    
    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar (self._uiDriver, self, self._form)

    # and the Statusbar
    if not self._form._features ['GUI:STATUSBAR:SUPPRESS']:
      self.createStatusBar ()
          

    self._eventHandler = event.eventHandler
    self._wrapper.finalize ()
    self._visible = 0

    return newWidget


  # ---------------------------------------------------------------------------
  # Create the status bar
  # ---------------------------------------------------------------------------

  def createStatusBar (self):
    self.statusBar1 = gtk.Statusbar ()
    self.statusBar2 = gtk.Statusbar ()
    self.statusBar3 = gtk.Statusbar ()
    self.statusBar4 = gtk.Statusbar ()
    self.statusBar5 = gtk.Statusbar ()

    self.statusBar1.set_has_resize_grip (False)
    self.statusBar2.set_has_resize_grip (False)
    self.statusBar3.set_has_resize_grip (False)
    self.statusBar4.set_has_resize_grip (False)
    self.statusBar5.set_has_resize_grip (False)

    status_bar_table = gtk.HBox (False)
    status_bar_table.pack_start (self.statusBar1)
    
    status_bar_table2 = gtk.HBox(False)
    status_bar_table2.pack_start (self.statusBar2)
    status_bar_table2.pack_start (self.statusBar3)
    status_bar_table2.pack_start (self.statusBar4)
    status_bar_table2.pack_start (self.statusBar5)

    status_bar_table.pack_start (status_bar_table2)

    self.content_table.attach(status_bar_table,
                 # X direction           Y direction
                 0,1,                    3, 4,
                 gtk.EXPAND | gtk.FILL,  0,
                 0,                      0)
                                                
  # ---------------------------------------------------------------------------
  # Makes the requested page visible while hiding the others
  # ---------------------------------------------------------------------------

  def gotoPage (self, page):
    self._wrapper.setPage (page.widgets [0])
          
                     
  # ---------------------------------------------------------------------------
  # set values in the corresponding status bars
  # ---------------------------------------------------------------------------

  def _setStatusBar (self, tip, statusValue, insertValue, currentRecord,
                    maxRecord, currentPage, maxPage):
    
    if not hasattr (self, 'statusBar1'):
      return
    
    if tip is not None:
      text = self._makeSafe ("%s" % tip)
      context = self.statusBar1.get_context_id ('tip')
      self.statusBar1.push (context, text)

    if statusValue:
      context = self.statusBar2.get_context_id ('statusValue')
      self.statusBar2.push (context, self._makeSafe (statusValue))
      
    if insertValue:
      context = self.statusBar3.get_context_id ('insertValue')
      self.statusBar3.push (context, self._makeSafe (insertValue))

    if currentRecord and maxRecord:
      context = self.statusBar4.get_context_id ('currentRecord_and_maxRecord')
      text    = string.strip ("%s/%s" % (currentRecord, maxRecord))
      self.statusBar4.push (context, self._makeSafe (text))

    if currentPage and maxPage:
      context = self.statusBar5.get_context_id ('currentPage_and_maxPage')
      text    = string.strip ("%s/%s" % (currentPage, maxPage))
      self.statusBar5.push (context, self._makeSafe (text))

    self._uiDriver.processMessages ()


  # ---------------------------------------------------------------------------
  # show the current form non-modal
  # ---------------------------------------------------------------------------

  def show (self):

    # show_all moves the focus, so we have to remember where it was before and
    # restore it
    widget = self.mainWindow.get_focus ()

    self.mainWindow.show_all ()

    if widget != self.mainWindow.get_focus ():
      widget.grab_focus ()

    self._visible = 1
    if self._form.style == 'dialog':
      self.mainWindow.run ()


  # ---------------------------------------------------------------------------
  # Hide the current form
  # ---------------------------------------------------------------------------

  def hide (self):
    self.containerFrame.hide ()
    self.mainWindow.hide ()
    self.mainWindow.set_modal (False)
    self._visible = 0
    

  # ---------------------------------------------------------------------------
  # Show the current form modal
  # ---------------------------------------------------------------------------

  def showModal (self):

    # show_all moves the focus, so we have to remember where it was before and
    # restore it
    widget = self.mainWindow.get_focus ()

    self.mainWindow.show_all ()
    self.mainWindow.set_modal (True)

    if widget != self.mainWindow.get_focus ():
      widget.grab_focus ()

    self._visible = 1
    if self._form.style == 'dialog':
      self.mainWindow.run ()
    

  # ---------------------------------------------------------------------------
  # Catch the exit event from the menu and request exit
  # ---------------------------------------------------------------------------

  def windowExitEvent (self, widget, event):

    self._uiDriver.dispatchEvent ('requestEXIT', _form = self._form)

    return True
