# GNU Enterprise Forms - GTK UI driver - Scrollbar Widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: scrollbar.py 7008 2005-02-11 17:03:06Z reinhard $

import gtk

from gnue.common import events
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

# =============================================================================
# This class implements a scrollbar for navigating multiple records
# =============================================================================

class UIScrollBar (UIHelper):

  # ---------------------------------------------------------------------------
  # Create the GTK widget
  # ---------------------------------------------------------------------------

  def _createWidget (self, event, spacer):
    gfObject = event.object
    gfBlock  = gfObject._block

    self.adjustment = gtk.Adjustment (1, 1, gfBlock._recordCount, 1)

    newWidget = gtk.VScrollbar (self.adjustment)
    height    = gfObject.Char__height * event.widgetHeight
    newWidget.set_size_request (-1, height)
    self.adjustment._scrollHandler = self.adjustment.connect ('value-changed',
                                                self._scrollHandler, gfObject)
    
    event.container.put (newWidget, self.itemX, self.itemY)
    newWidget.show ()

    gfBlock.registerScrollbar (self)
    
    return newWidget


  # ---------------------------------------------------------------------------
  # Handle changes of the adjustment's value
  # ---------------------------------------------------------------------------

  def _scrollHandler (self, adjustment, gfObject):

    gDebug (6, "Adjust to %s" % (int (adjustment.value)))
    action = events.Event ('requestRECORDNUMBER', int (adjustment.value),
                           _form = gfObject._form)
    adjustment.stop_emission ('value-changed')
    gtk.idle_add (self._eventHandler, action)

    return True


  # ---------------------------------------------------------------------------
  # adjust the scrollbar to a new position
  # ---------------------------------------------------------------------------

  def adjustScrollbar (self, position, count):
    if int (self.adjustment.upper) != count:
      self.adjustment.upper = float (count)

    newPos = position + 1
    self._blockHandler (self.adjustment, '_scrollHandler')
    self.adjustment.set_value (newPos)
    self._blockHandler (self.adjustment, '_scrollHandler', True)


# -----------------------------------------------------------------------------
# Configuration data
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UIScrollBar,
  'provides'   : 'GFScrollBar',
  'container'  : 0,
}
