#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A QT based user interface driver for GNUe forms.
#
# NOTES:
#

import string, os

from qt import *

from gnue.common.datasources import GLoginHandler
from gnue.common.apps import GConfig
from QTApp import *

# Shortcut
images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'


#####################################################################
##
## Login Support
##
## Everything below this point is in support of the wx drivers
## UILoginHandler
##  
#####################################################################

#
# UILoginHandler
#
class UILoginHandler(GLoginHandler.LoginHandler):
  def __init__(self):
    self._qtapp = getQtApp()
    self.dlg = None

  def getLogin(self, loginData, errortext=None):
      if len(loginData[1]):
        loginMesg = _('Login required for\n"%s"') % (loginData[1])
      else:
        loginMesg = _('Login required for %s') % (loginData[0])

      self.dlg = QDialog(None, _("GNU Enterprise: Login to %s") % loginData[0], 1)
      self.dlg.setCaption ( _("GNU Enterprise: Login to %s") % loginData[0])

      if os.path.isabs(gConfigForms('loginPNG')):
        imageFile = gConfigForms('loginPNG')
      else:
        imageFile = images_dir+gConfigForms('loginPNG')

      bmp = QPixmap(imageFile)
      messageField = WrappedStaticText(self.dlg, str(loginMesg), 300)

      self.textctrlList = []
      labelList = []

      dlgWidth = max(bmp.width(), messageField.width()+20)

      dlgHeight = bmp.height() + messageField.height() + 80

      xSpacing = 0
      ySpacing = 0
      fieldLabelWidth = 0

      for prompt in loginData[2]:
        s = QLabel('%s:' % prompt[1], self.dlg)
        labelList.append(s)
        t = QLineEdit(self.dlg)
        t.setFixedWidth(150)
        if prompt[2]:
          t.setEchoMode(QLineEdit.Password)

        myID = len(self.textctrlList)
        self.textctrlList.append(t)
##        EVT_CHAR(t, LoginFieldHandler(self, myID).loginFieldEventTrap)

        fieldLabelWidth = max(fieldLabelWidth,
                  s.width() + t.width() + 10)

        dlgWidth = max(dlgWidth, \
                       s.width() + t.width() + 20)

        xSpacing = max(xSpacing, s.width())
        ySpacing = max(ySpacing, s.height())
        ySpacing = max(ySpacing, t.height())


##      loginId = wxNewId()
##      cancelId = wxNewId()

      loginButton = QPushButton(self.dlg)
      loginButton.setText(_('Login'))
      loginButton.show()
      cancelButton = QPushButton(self.dlg)
      cancelButton.setText(_('Cancel'))
      cancelButton.show()

      QObject.connect(loginButton, SIGNAL("clicked()"),
                     self.loginButtonEventTrap)
      QObject.connect(cancelButton, SIGNAL("clicked()"),
                     self.loginCancelEventTrap)
      
      dlgWidth = max(dlgWidth, loginButton.width() +
                            cancelButton.width() + 6) + 20

      dlgHeight += max(loginButton.height(),
                       cancelButton.height()) - 6

      if errortext:
        errorField = WrappedStaticText(self.dlg, str(errortext), 300)
##        errorField.SetForegroundColour(wxColour(223,0,0))

        dlgWidth = max(dlgWidth, errorField.width()+10)
        dlgHeight += errorField.height() + 6


      firstY = bmp.height() + messageField.height() + 50
      lastY = firstY
      xSpacing += 10	# Add whitespace between widgets
      ySpacing += 6	# Add whitespace between widgets
      xPos = dlgWidth/2 - fieldLabelWidth/2


      # Move the fields and labels into position
      for i in range(0, len(self.textctrlList)):
        dlgHeight = dlgHeight + ySpacing
        labelList[i].move(xPos, lastY)
        self.textctrlList[i].move(xPos + xSpacing, lastY)
        lastY = lastY + ySpacing
        self.textctrlList[i].show()
        
      if errortext:
        errorField.move(
          dlgWidth/2 - errorField.width()/2,
                lastY+3)

      # Set the focus to the first text entry field
      self.textctrlList[0].setFocus()

      # Create and position the logo
      img = QLabel(self.dlg)
      img.setFrameRect(QRect(dlgWidth-bmp.width()/2, 12, bmp.width(), bmp.height()))
      img.setPixmap(bmp)
      
      img.show()

      # Move the various widgets into position
      messageField.move(
        dlgWidth/2 - messageField.width()/2,
                30 + bmp.height())

      cancelButton.move(
         dlgWidth - 10 - cancelButton.width(),
                dlgHeight - 10 - max(loginButton.height(),
                                            cancelButton.height()))

      loginButton.move(
        dlgWidth - 16 - cancelButton.width() - \
                loginButton.width(),
                dlgHeight - 10 - max(loginButton.height(),
                                            cancelButton.height()))

      self.loginButton = loginButton

      self.dlg.setFixedSize(dlgWidth, dlgHeight)

      # If user cancels, this will be set to 0
      self._accept = 0
      completed = self.dlg.exec_loop()

      if completed == QDialog.Rejected:
        raise GLoginHandler.UserCanceledLogin

      rv = {}
      for i in range(0, len(loginData[2])):
        rv[loginData[2][i][0]] = unicode(self.textctrlList[i].text())

      return rv


  #
  # Called when user clicks "login"
  #
  def loginButtonEventTrap(self):
    self.dlg.accept()

  #
  # Called when user clicks "cancel"
  #
  def loginCancelEventTrap(self):
    self.dlg.reject()

  #
  # TODO: This is a hack required because windows
  # TODO: seems to have issues with wxWidgets dialogs
  #
  def destroyLoginDialog(self):
    self.dlg.hide()


    
    
class WrappedStaticText(QLabel):
  def __init__(self, parent, label, width):
    QLabel.__init__(self, label, parent)

##    QLabel.setFixedWidth(width)

    textSoFar = ""
    thisLine = ""
    for part in string.split(label,'\n'):
      for word in string.split(part):
        self.setText(thisLine + word)
        if self.width() > width:
          textSoFar += thisLine + " \n"
          thisLine = word + " "
        else:
          thisLine += word + " "

      textSoFar += thisLine + " \n"
      thisLine = ""

    if len(textSoFar):
      self.setText(string.replace(textSoFar,' \n','\n')[:-1])
    else:
      self.setText("")

