# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# $Id: MenuBar.py 7657 2005-06-26 11:09:49Z btami $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32gui
import win32con

from gnue.common import events

from gnue.forms.uidrivers._commonGuiToolkit.MenuBar import MenuBar as _BaseMenuBar
from gnue.forms.uidrivers.win32.common import getNextId, textEncode

_menustyle = win32con.MF_STRING

class MenuBar(_BaseMenuBar):

  # Create the menu
  def init(self):
    self.menu = win32gui.CreateMenu()
    return self.menu

  # Add a (sub)menu
  def addMenu(self, name, parent):
    menu = win32gui.CreatePopupMenu()
    win32gui.AppendMenu(parent, _menustyle | win32con.MF_POPUP, menu, textEncode(name))
    # One would think this would go in init(),
    # but, no... win32 has to be a jerkoff.
    win32gui.SetMenu(self.container.GetHwnd(), self.menu )
    return menu

  # Add a menu item (action)
  def addAction(self, name, parent, userAction):
    label = name
    hotkey = userAction.getHotKeyText()
    iconloc = userAction.getIconLocation(size="16x16")

    if hotkey:
      label += '\t%s' % hotkey

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        pass

    id = getNextId()
    self.container.addDescription(id, textEncode(userAction.description) or '')
    win32gui.AppendMenu(parent, _menustyle, id, textEncode(label))
    event = 'request' + userAction.event
    self.container.Connect(id, lambda l=self.driver, e=event, f=self.form: l.dispatchEvent(events.Event(e,_form=f)))

    return (parent, id)


  # Add a separator
  def addSeparator(self, parent):
    win32gui.AppendMenu(parent, win32con.MF_SEPARATOR, 0, "")

  # Enable a menu item
  def enableItem(self, item):
    parent, id = item
    try:
      win32gui.EnableMenuItem(parent, id, win32con.MF_BYCOMMAND|win32con.MF_ENABLED)
    except:
      pass

  # Disable a menu item
  def disableItem(self, item):
    parent, id = item
    try:
      win32gui.EnableMenuItem(parent, id, win32con.MF_BYCOMMAND|win32con.MF_GRAYED)
    except:
      pass

_cachedIcons = {}

