# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFDisplayHandler.py
#
# $Id$
"""
DisplayHandler classes for Forms input validation
"""
__revision__ = "$Id$"

from gnue.forms.input.displayHandlers.Cursor import BaseCursor

#############################################################################
#
# Handler for Listbox types
#
class Listbox(BaseCursor):

  def __init__(self, entry, eventHandler, subEventHandler, displayMask,
               inputMask):

    BaseCursor.__init__(self, entry, eventHandler, subEventHandler)

    # My events...
    self.subEventHandler.registerEventListeners( {
           'requestREPLACEVALUE' : self._replaceText } )


  def _beginEdit(self, event):
    if self.editing == True and self.modified == False:
      return

    if not self._loadedAllowedValues and not hasattr(self.field,'_allowedValues'):
      self.field.allowedValues()
      self._loadedAllowedValues = True

    self.editing = True
    self.modified = False

    # TODO: Replace with formatter
    self.setValue(self.field.getValue())

    if self.value == None:
      self.work = ""
    else:
      try:
        self.work = self.field._allowedValues ["%s" % self.value]
      except KeyError:
        self.work = ""
        event.__error__ = True
        event.__errortext__ = u_("Invalid value '%s' for keyed pull-down "
                                 "field") % self.value

    self._buildDisplay()

    self._cursor = len(self.display)

  # TODO: Replace with format mask
  def _buildDisplayHelper(self, value, editing):
    if value in (None, ""):
      return ""

    if editing:
      val = value.lower()
      for disp in self.field._allowedValuesDescr:
        if disp[:len(val)].lower() == val:
          display = self.field._allowedValues[self.field._allowedValuesReverse[disp]]
          return display
      return value

    if self.field._allowedValues.has_key ("%s" % value):
      return self.field._allowedValues ["%s" % value]
    else:
      return ""

  def _buildDisplay(self):
    if self.editing:
      self.display = self._buildDisplayHelper(self.work, True)
      if self._cursor > len(self.work):
        self.work = self.display
    else:
      self.display = self._buildDisplayHelper(self.value, False)


  def _replaceText(self, event):
    self._selection1 = 0
    self._selection2 = len(self.display)
    self._addText(event)
