#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFDisplayHandler.py
#
# $Id$
"""
DisplayHandler classes for Forms input validation
"""
__revision__ = "$Id$"

from gnue.forms.input.displayHandlers.Cursor import BaseCursor

class Password(BaseCursor):
  """
  Password display handler.
  
  Deals the entries of style password.  Replaces the value that would 
  have been displayed with *s.  Also disables cut and paste functionality
  as a security percaution.
  """  
  def __init__(self, entry, eventHandler, subEventHandler, displayMask,
               inputMask):
    """
    Class initializer.
    """
    BaseCursor.__init__(self, entry, eventHandler, subEventHandler)

  def _beginEdit(self, event):
    """
    Notifies the handler that it will be doing edits.
    
    Serves the same function as the method in FieldDisplayHandler
    except for the initial display value?
    """
    self.editing = self.field.isEditable(event._form.getCurrentMode())
    self.modified = False

    # TODO: Replace with formatter
    self.setValue(self.field.getValue())
    self.work = self.value
    self._buildDisplay()

    self.cursor = len(self.display)
    # Ensure cursor is properly placed.
    self.generateRefreshEvent()


  def _buildDisplayHelper(self, value, editing):
    """
    Builds a string that represents what should be 
    displayed for the field.

    For password entry fields this is simply a string of *s
    """
    if value == None:
      return ""
    else:
      return "*" * len(str(value))

  def _clipboardCopy(self, event):
    """
    Handle requests for a copy of the display value to be placed 
    into the systems clipboard
    
    This is disabled for password field types.
    """
    assert gDebug(4, "Entry %s: Password style entry.  Copy disabled." % self.entry.name)

  def _clipboardCut(self, event):
    """
    Handle requests for a the display value to be cut and placed 
    into the systems clipboard
    
    This is disabled for password field types.
    """
    assert gDebug(4, "Entry %s: Password style entry.  Cut disabled." % self.entry.name)
