#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: scrollbar.py 7954 2005-09-21 18:10:06Z reinhard $

from wxPython.wx import *

from gnue.common import events
from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow
from gnue.forms.uidrivers.wx.common import _setDefaultEventHandlers


# =============================================================================
# Wrap an UI layer around a scrollbar used to navigating multiple records
# =============================================================================
class UIScrollBar(UIHelper):
  """
  Creates a single instance of a scrollbar.
  """

  # --------------------------------------------------------------------------
  # Create a scrollbar widget
  # --------------------------------------------------------------------------
  def _createWidget (self, event, spacer):
    """
    Creates a new wxScrollBar widget.
    """
    gfObject = event.object

    itemX =      self.itemX
    itemY =      (gfObject.Char__y + spacer) * event.widgetHeight
    itemWidth =  gfObject.Char__width * event.widgetWidth
    itemHeight = gfObject.Char__height * event.widgetHeight

    newWidget = self._widget = wxScrollBar (event.container, -1,
                           wxPoint(itemX, itemY),
                           wxSize(itemWidth, itemHeight),
                           wxSB_VERTICAL)

    if event.initialize:
      self._eventHandler = event.eventHandler
      EVT_COMMAND_SCROLL (newWidget, newWidget.GetId (), self.scrollbarHandler)
      _setDefaultEventHandlers (newWidget, event.eventHandler,
          event.initialize,self._uiDriver)

    (crec, recs, self.pageSize) = gfObject.getRecordAndPageCount ()
    self.adjustScrollbar (crec, recs)

    return newWidget


  # --------------------------------------------------------------------------
  # Handle scrollbar events
  # --------------------------------------------------------------------------
  def scrollbarHandler (self, event):
    """
    Handles scrollbar events.
    """
    object = _eventObjTowxWindow(event)
    id = object.GetId ()

    self._gfObject.scrollToRecord (int (object.GetThumbPosition ()))


  # --------------------------------------------------------------------------
  # Adjusts scrollbar pos and size
  # --------------------------------------------------------------------------
  def adjustScrollbar (self, current, count):
    """
    Adjusts the scrollbar's position and size
    """

    # position, thumbSize, range, pageSize, refresh = TRUE
    self._widget.SetScrollbar (current, self.pageSize, count, self.pageSize - 1)


# ----------------------------------------------------------------------------
# Configuration data
# ----------------------------------------------------------------------------
configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
