#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GFEntry.py
#
# DESCRIPTION:
"""
The primary data entry widget in forms
"""
# NOTES:
#

from gnue.common.apps import GDebug
from gnue.forms import GFDisplayHandler
from GFValue import GFValue
from GFTabStop import GFTabStop
import string

############################################################
# GFEntry
#
# Matches the Entry form tag in the gfd
#
# It send events to its parent GFBlock
#
class GFEntry(GFTabStop):
  def __init__(self, parent=None, value=None):
    GFTabStop.__init__(self, parent, 'GFEntry')

    # Default attributes (these may be replaced by parser)
    self.Char__height = int(gConfigForms('widgetHeight'))
    self.Char__width = int(gConfigForms('widgetWidth'))
    self.style = "default"
    self.label = ""

    self._inits = [self.initialize]

    self._rows = 1
    self._gap = 0

    # TODO: Conversion: Dunno about any of these triggers
    #
    # Trigger exposure
    #
    self._validTriggers ={ 'PRE-FOCUSOUT':   'Pre-FocusOut',
                           'POST-FOCUSOUT':  'Post-FocusOut',
                           'PRE-FOCUSIN':    'Pre-FocusIn',
                           'POST-FOCUSIN':   'Post-FocusIn',
                         }
    self._triggerFunctions={'set':{'function':self.triggerSetValue},
                            'get':{'function':self.getValue}
                            }
    self._triggerSet = self.triggerSetValue
    self._triggerGet = self.getValue

    self._triggerProperties = {
                                'rows': { 'get': self._getRows,
                                        }
                              }

  def _buildObject(self):
    return GFTabStop._buildObject(self)

  def initialize(self):

    #
    # Find parents/relatives
    #

    # ...Block
    try:
      self._block = block = self.findParentOfType('GFForm')._logic._blockMap[self.block]
      block._entryList.append(self)
    except KeyError:
      raise "Entry references non-existent block '%s'" % self.block

    # ...Field
    try:
      self._field = field = block._fieldMap[self.field]
      field._entryList.append(self)
    except KeyError:
      raise "Entry references non-existent field '%s'" % self.field

    # ...Page
    self._page = self.findParentOfType('GFPage')
    self._page._entryList.append(self)

    self._form = self._block._form


    # Navigable? or no?
    self._navigable = self.navigable
    if self.style == 'label' or self.hidden:
      self._navigable = 0
      self._queryable = 0 # TODO: is this used?

    self._formatmask = ""
    self._inputmask = hasattr(self,'inputmask') and self.inputmask or ""
    self._displaymask = hasattr(self,'displaymask') and self.displaymask or ""

    # TODO: Conversion: I'm torn... does this go here or in GFField??
    # Create an appropriate display handler
    if self.style == 'checkbox':
      self._displayHandler = GFDisplayHandler.CheckboxDisplayHandler(self,
               self._form._instance.eventController)
    elif self.style == 'dropdown':
      self._displayHandler = GFDisplayHandler.DropdownDisplayHandler(self,
               self._form._instance.eventController)
    elif self.style == 'password':
      self._displayHandler = GFDisplayHandler.PasswordDisplayHandler(self,
               self._form._instance.eventController,
               self._displaymask, self._inputmask)
    elif self._field.typecast == 'text':
      self._displayHandler = GFDisplayHandler.TextDisplayHandler(self,
               self._form._instance.eventController,
               self._displaymask, self._inputmask)
    elif self._field.typecast == 'number':
      self._displayHandler = GFDisplayHandler.NumberDisplayHandler(self,
               self._form._instance.eventController,
               self._displaymask, self._inputmask)
    elif self._field.typecast == 'date':
      self._displayHandler = GFDisplayHandler.DateDisplayHandler(self,
               self._form._instance.eventController,
               self._displaymask, self._inputmask)

    # Row settings
    if hasattr(self,'rows'):
      self._rows = self.rows
    else:
      self._rows = self._field._rows

    if hasattr(self,'rowSpacer'):
      self._gap = self.rowSpacer
    else:
      self._gap = self._field._gap


  # TODO: Conversion:  Does this belong here or not?
  def getValue(self, *args, **parms):
    return self._field.getValue(*args, **parms)

  # TODO: Conversion:  Does this belong here or not?
  def triggerSetValue(self, *args, **parms):
    return self._field.triggerSetValue(*args, **parms)

  def _getRows(self):
    return self._rows
  