#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Logical page support
"""
# NOTES:
#

from GFObj import GFObj

#
# GFPage
#
class GFPage(GFObj):
  def __init__(self, parent=None):
    GFObj.__init__(self, parent,"GFPage")
    self._inits = [self.initialize, self.init2]

    self._validTriggers = { 
                  'PRE-FOCUSOUT':   'Pre-FocusOut',
                  'POST-FOCUSOUT':  'Post-FocusOut',
                  'PRE-FOCUSIN':    'Pre-FocusIn',
                  'POST-FOCUSIN':   'Post-FocusIn',
                  }

    self._entryList = []


  def initialize(self):
    self._form = self.findParentOfType('GFForm')
    
    layout = self.findParentOfType('GFLayout')
    layout._pageList.append(self)

  def init2(self):
    # Get all focusable items, ordered correctly
    self._focusOrder = self._entryList # self.getFocusOrder()











