#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GFParser.py
#
# DESCRIPTION:
"""
Class that contains a sax based xml processor for GNUe forms

NOTES:
 * Designer uses the 'Positionable' attribute. It is specific to
   forms+designer and is not part of the GParser spec. If set to
   true, then this object is a visible, movable, sizable attribute.
"""

from gnue.common.datasources import GDataSource
from gnue.common.definitions import GParser
from gnue.common.formatting import GTypecast
from gnue.common.logic import GTrigger
from gnue.common import GMenu

import copy, types





########
########  Please keep this file neat !!!
########





##
##
##
def loadFile(buffer, instance, initialize=True):
  """
  This method loads a form from an XML file and returns
  a GFForm object.  If initialize is 1 (default), then
  the form is initialized and ready to go.

  (initialize=0 is currently not used -- will probably
  be used in the Forms Designer package where we will
  not want the loaded form to connect to databases, etc)
  """
  return GParser.loadXMLObject (buffer, xmlFormsHandler, 'GFForm', 'form',
           initialize, attributes={"_instance": instance,
                               "_parameters": instance._parameters,
                               "_connections": instance.connections })


xmlElements = None


def getXMLelements():

  global xmlElements

  if xmlElements == None:
    from gnue.forms import GFObjects, GFLibrary, GFForm

    xmlElements = {
      'form': {
         'BaseClass': GFForm.GFForm,
         'Required': True,
         'SingleInstance': True,
         'Attributes': {
            'title': {
               'Typecast': GTypecast.text,
               'Default': 'Untitled Form',
               'Label': _('Title'),
               'Description': 'The title of the form.' },
            'readonly': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Label': _('Read Only'),
               'Description': 'If set to {Y}, then no modifications to data '
                              'by the end user will be allowed. The form will '
                              'become a query-only form.' },
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'A unique name or ID for the form.' },
            'style': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'normal': {'Label': _('Normal')},
                  'dialog': {'Label': _('Dialog')} },
               'Default': 'normal',
               'Description': ''  }, },
         'ParentTags': None,
         'Description': 'TODO' },

      'logic': {
         'BaseClass': GFObjects.GFLogic,
         'Required': True,
         'Importable': True,
         'SingleInstance': True,
         'ParentTags': ('form',),
         'Description': 'TODO' },

      'layout': {
         'BaseClass': GFObjects.GFLayout,
         'Required': True,
         'Importable': True,
         'SingleInstance': True,
         'ParentTags': ('form',),
         'Description': 'TODO' ,
         'Attributes': {
           'tabbed': {
             'Typecast': GTypecast.name,
             'Label': _('Tab Location'),
             'ValueSet': {
                'none':   {'Label': _('No tabs')},
                'left':   {'Label': _('Left tab')},
                'right':  {'Label': _('Right tab')},
                'bottom': {'Label': _('Botton tab')},
                'top':    {'Label': _('Top tab')} },
           'Default': "none",
           'Description': 'Informs the UI subsystem to display a form\'s pages as '
                        'notebook tabs. Allowed values are {left}, '
                        '{right}, {bottom}, {top}.  If the UI driver in use does not support the chosen tab position (or tabs at all,) then the UI driver may choose another tab position.' } } } ,

      'page': {
         'BaseClass': GFObjects.GFPage,
         'Required': True,
         'Importable': True,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'A unique ID for the widget. This is only useful '
                              'when importing pages from a library.' },
            'transparent':{
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'If set, then you can tab out of the page via next- '
                              'or previous-field events. Makes navigation in '
                              'mutlipage forms easier. If false, focus stays '
                              'within a page until user explicitly moves to '
                              'another page' },
            'style': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'normal': {'Label': _('Normal')},
## TODO ##         'popup': {},
                   },
               'Default': 'normal',
               'Description': 'The type of page.' },
            'caption': {
               'Typecast': GTypecast.text,
               'Description': 'For {tabbed} or {popup} pages, this contains the caption to use for the page.' } },
         'ParentTags': ('layout',),
         'Description': 'TODO' },

      'block': {
         'BaseClass': GFObjects.GFBlock,
         'Required': True,
         'Importable': True,
         'Attributes': {
            'name': {
               'Required': True,
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'A unique ID (name) for the widget. '
                              'No blocks can share '
                              'the same name without causing namespace '
                              'collisions in user triggers.' },
            'rows': {
               'Typecast': GTypecast.whole,
               'Description': 'Any widgets inside the block will display this '
                              'number of copies in a verticle column. Simulates '
                              'a grid entry system.'},
            'rowSpacer': {
               'Typecast': GTypecast.whole,
               'Label': _('Row Spacing'),
               'Description': 'Adjusts the vertical gap of this number of rows '
                              'between duplicated widgets. Serves the same '
                              'purpose as some of the gap attributes on '
                              'individual widgets.' },
            'transparent':{
               'Typecast': GTypecast.boolean,
               'Default': True,
               'Description': 'If set, then you can tab out of the block via next- '
                              'or previous-field events. Makes navigation in '
                              'multiblock forms easier. If false, focus stays '
                              'within a block until user explicitly moves to '
                              'another block' },
            'restrictDelete':{
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Label': _('Prevent Deletes'),
               'Description': 'If set then the user will be unable to request '
                               'that a record be deleted via the user interface.' },
            'restrictInsert':{
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Label': _('Prevent Inserts'),
               'Description': 'If set then the user will be unable to request '
                              'that new records be inserted into the block.' },
            'datasource': {
               'References': 'datasource.name',
               'Typecast': GTypecast.name,
               'Description': 'The name of a datasource (defined in by a '
                              '{<datasource>} tag) that provides this block '
                              'with it\'s data.' } },
         'ParentTags': ('logic',),
         'Description': 'TODO' },

      'label': {
         'BaseClass': GFObjects.GFLabel,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'The unique ID of the label.' },
            'text': {
               'Required': True,
               'Typecast': GTypecast.text,
               'Description': 'The text to be displayed.' },
            'alignment': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'left': {'Label': _('Left')},
                  'right': {'Label': _('Right')},
                  'center': {'Label': _('Centered')} },
               'Default': "left",
               'Description': 'The justification of the label. Can be one of '
                              'the following: {left}, {right}, or {center}. '
                              'Requires that the {width} attribute be set.'},
##            'width': {
##               'Typecast': GTypecast.whole,
##               'Description': 'The width of the label in text columns. '
##                              'Defaults to the width of the text. Only really '
##                              'useful when used with the {alignment} attribute.' },
            'rows': {
               'Typecast': GTypecast.whole,
               'Description': 'Overrides the rows setting defined at the block level. ' },
            'rowSpacer': {
               'Typecast': GTypecast.whole,
               'Label': _('Row Spacing'),
               'Description': 'Overriders the rowSpace setting defined at the block level.' } },
##            'x': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text column starting position of the widget. Based upon leftmost column of screen being 0. ' },
##            'y': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text row starting position of the widget. Based upon the top row of the screen being 0.' } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },

      'field': {
         'BaseClass': GFObjects.GFField,
         'Importable':1,
         'Attributes': {
            'name': {
               'Required': True,
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'The unique ID of the entry. Referenced in '
                              'master/detail setups as well as triggers.' },
            'field': {
               'Typecast': GTypecast.name,
               'Label': _('Field (Database)'),
               'Description': 'The name of the field in the datasource to '
                              'which this widget is tied.' },
            'max_length': {
               'Typecast': GTypecast.whole,
               'Description': 'The maximum number of characters the user is '
                              'allowed to enter into the entry.' },
            'min_length': {
               'Typecast': GTypecast.whole,
               'Description': 'The minimum number of characters the user must '
                              'enter into the entry.',
               'Default': 0 },
            'readonly': {
               'Typecast': GTypecast.boolean,
               'Label': _('Read Only'),
               'Description': 'It defined the user will be unable to alter '
                              'the contents of this entry. Triggers can still '
                              'alter the value.',
               'Default': False   },
            'required': {
               'Description': 'This object cannot have an empty value prior '
                              'to a commit.',
               'Typecast': GTypecast.boolean,
               'Default': False   },
            'case': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'mixed': {'Label': _('Mixed case (no conversion)')},
                  'upper': {'Label': _('Convert to upper case')},
                  'lower': {'Label': _('Convert to lower case')} },
               'Default': 'mixed',
               'Description': 'TODO'  },
            'typecast': {
               'Typecast': GTypecast.name,
               'Label': _('Data Type'),
               'ValueSet': {
                  'text': {'Label': _('Text')},
                  'number': {'Label': _('Numeric')},
                  'date': {'Label': _('Date/Time')} },
               'Default': 'text',
               'Description': 'The type of data the entry widget will accept. '
                              'Possible values are {text}, {number}, {date}.'},
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' },
##            'foreign_key': {
##               'Typecast': GTypecast.name,
##               'Deprecated': 'Use fk_source="..." and fk_key="..." instead.',
##               'Description': 'Set in the format datasource.field This forces any '
##                              'input into this entry to match the values stored '
##                              'in the datasource.field' },
##            'foreign_key_description': {
##               'Typecast': GTypecast.text,
##               'Deprecated': 'Use fk_description="..." instead.',
##               'Description': 'The description used if a style of dropdown is '
##                              'selected. This fields value is displayed in the '
##                              'dropdown but the foreign_key value is actually '
##                              'stored in the field. This allows you to display '
##                              'something like the full name of a US state but '
##                              'only store it\'s 2 character abrievation.' },
            'fk_source': {
               'References': 'datasource.name',
               'Label': _('F/K Datasource'),
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'fk_key': {
               'Label': _('F/K Bound Field'),
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'fk_description': {
               'Typecast': GTypecast.name,
               'Label': _('F/K Description Field'),
               'Description': 'TODO' },
            'fk_refresh': {
               'Typecast': GTypecast.name,
               'Label': _('F/K Refresh Method'),
               'ValueSet': {
                  'startup': {'Label': _('Only refresh on form startup')},
                  'change': {'Label': _('Refresh on field modification')},
                  'commit': {'Label': _('Refresh after record is committed')} },
               'Default': 'startup',
               'Description': 'TODO' },
            'default': {
               'Typecast': GTypecast.text,
               'Label': _('Default (New Record)'),
               'Description': 'The default value for any new records created. '
                              'If the field is visible the user can override '
                              'the value.' },
            'defaultToLast': {
               'Typecast': GTypecast.boolean,
               'Label': _('Default to last entry?'),
               'Default': False,
               'Description': 'If true, then new records will default to the '
                              'last value the user entered for this field. If '
                              'no new values have been entered, then defaults '
                              'back to the normal {default} setting.' },
            'queryDefault':{
               'Typecast': GTypecast.text,
               'Label': _('Default (Query)'),
               'Description': 'The form will be populated with this value '
                              'automatically when a query is requested. If '
                              'the field is visible the user can still '
                              'override the value.' },
            'sloppyQuery': {
               'Typecast': GTypecast.text,
               'Label': _('Sloppy Queries'),
               'Description': 'When set, whatever value the user enters for '
                              'the query mask is rewritten with % between '
                              'each character. Thus {example} would be '
                              'queried as {%e%x%a%m%p%l%e%}' },
            'ignoreCaseOnQuery': {
               'Typecast': GTypecast.boolean,
               'Label': _('Ignore Case on Queries'),
               'Default': False,
               'Description': 'If defined the entry widget ignores the case '
                              'of the information entered into the query mask.' },
            'editOnNull': {
               'Description': 'Only allow this object to be edited if it '
                              'is currently empty.',
               'Label': _('Edit Only When Null'),
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'TODO' },
            'ltrim': {
               'Label': _('Trim left spaces'),
               'Description': 'Trim extraneous space at '
                              'beginning of user input.',
               'Typecast': GTypecast.boolean,
               'Default': False },
            'rtrim': {
               'Label': _('Trim right spaces'),
               'Description': 'Trim extraneous space at end '
                              'of user input.',
               'Typecast': GTypecast.boolean,
               'Default': False } },
         'ParentTags': ('block',),
         'Description': 'TODO' },

      # If you implement a new entry "style", add to the entryStyles
      # structure after this list
      'entry': {
         'BaseClass': GFObjects.GFEntry,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'The unique ID of the entry.' },
            'label': {
               'Required': False,
               'Typecast': GTypecast.text,
               'Description': 'The optional label displayed next to checkbox.' },
            'field': {
               'Typecast': GTypecast.name,
               'References': 'field.name',
               'Required': True,
               'Description': 'The name of the field that this ties to.' },
            'block': {
               'Typecast': GTypecast.name,
               'Required': True,
               'References': 'block.name',
               'Description': 'The name of the block that this ties to.' },
##            'height': {
##               'Typecast': GTypecast.whole,
# ##               'Default': 1,
##               'Description': 'The height of the entry in text rows. ' },
##            'width': {
##               'Typecast': GTypecast.whole,
##               'Description': 'The width of the entry in text columns.' },
            'focusorder': {
               'Typecast': GTypecast.whole,
               'Label': _('Focus Order'),
               'Description': 'TODO'},
            'rows': {
               'Typecast': GTypecast.whole,
               'Description': 'TODO'},
            'rowSpacer': {
               'Typecast': GTypecast.whole,
               'Label': _('Row Spacing'),
               'Description': 'TODO' },
            'navigable': {
               'Typecast': GTypecast.boolean,
               'Description': 'If false, the user will be unable to navigate '
                              'to this entry. Triggers can still '
                              'alter the value.',
               'Default': True   },
            'hidden': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'If defined the entry widget will not be '
                              'displayed on the form. This is usefull for '
                              'fields the user doesn\'t need to know about '
                              'that you wish to update via triggers.'   },
            'style': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'default': {'Label': _('Default')},
                  'password': {'Label': _('Password/Hidden')},
                  'dropdown': {'Label': _('Dropdown/Combo box')},
                  'checkbox': {'Label': _('Checkbox')},
                  'label': {'Label': _('Label (non-editable)')} },
               'Default': 'default',
               'Description': 'The style of entry widget requested. Currently '
                              'either {text}, {label}, {checkbox}, or {dropdown}. To '
                              'use {dropdown} you are required to use both the '
                              '{fk_source}, {fk_key}, and {fk_description} '
                              'attributes. The {label} style implies the '
                              '{readonly} attribute.'  },
            'formatmask': {
               'Typecast': GTypecast.text,
               'Label': _('Format Mask'),
               'Description': 'TODO' },
            'inputmask': {
               'Typecast': GTypecast.text,
               'Label': _('Input Mask'),
               'Description': 'TODO' },
            'displaymask': {
               'Label': _('Display Mask'),
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
##            'x': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text column starting position of the '
##                              'widget. Based upon leftmost column of screen '
##                              'being 0.' },
##            'y': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text row starting position of the widget. '
##                              'Based upon the top row of the screen being 0.' } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'An {entry} is the visual counterpart to a {field}.' },

      'scrollbar': {
         'BaseClass': GFObjects.GFScrollBar,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'block': {
               'Required': True,
               'Typecast': GTypecast.name,
               'References': 'block.name',
               'Description': 'The {block} to which this scrollbar scrolls.' } },
##            'width': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The width of the box in text columns.' },
##            'height': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The height of the box in text rows.' },
##            'x': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text column starting position of the widget. Based upon leftmost column of screen being 0. ' },
##            'y': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text row starting position of the widget. Based upon the top row of the screen being 0.' } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },

      'box': {
         'BaseClass': GFObjects.GFBox,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'label': {
               'Typecast': GTypecast.text,
               'Description': 'An optional text label that will be displayed on the border.' },
##            'width': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The width of the box in text columns.' },
##            'height': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The height of the box in text rows.' },
            'focusorder': {
               'Typecast': GTypecast.whole,
               'Description': 'TODO'  } },
##            'x': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text column starting position of the widget. Based upon leftmost column of screen being 0. ' },
##            'y': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text row starting position of the widget. Based upon the top row of the screen being 0.' } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },
      'image': {
         'BaseClass': GFObjects.GFImage,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'field': {
               'Typecast': GTypecast.name,
               'References': 'field.name',
               'Required': True,
               'Description': 'The name of the field that this ties to.' },
            'block': {
               'Typecast': GTypecast.name,
               'References': 'block.name',
               'Required': True,
               'Description': 'The name of the block that this ties to.' },
            'type':        {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'URL': {'Label': _('Field contains the URL of the image')},
                  'PIL': {'Label': _('Field contains a PIL encoding of the image')} },
               'Default': "URL",
               'Description': 'TODO' },
            'focusorder': {
               'Typecast': GTypecast.whole,
               'Description': 'TODO'  } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },

      'component': {
         'BaseClass': GFObjects.GFComponent,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'field': {
               'Typecast': GTypecast.name,
               'References': 'field.name',
               'Required': True,
               'Description': 'The name of the field that this ties to.' },
            'block': {
               'Typecast': GTypecast.name,
               'References': 'block.name',
               'Required': True,
               'Description': 'The name of the block that this ties to.' },
            'mimetype':        {
               'Typecast': GTypecast.name,
               'Required': True,               
               'Description': 'TODO' },
            'type':        {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'URL': {'Label': _('Field contains the URL of the component')},
                  'Base64': {'Label': _('Field contains the data of the'+\
                                        ' component in Base63 encoding')} },
               'Default': "URL",
               'Description': 'TODO' },
            'focusorder': {
               'Typecast': GTypecast.whole,
               'Description': 'TODO'  } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },

      'button': {
         'BaseClass': GFObjects.GFButton,
         'Importable':1,
         'Attributes': {
            'name': {
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'A unique ID for the widget. Useful for importable buttons. ' },
            'block': {
               'Typecast': GTypecast.name,
               'References': 'block.name',
               'Description': 'The (optional) name of the block that this ties to. If a button is associated with a block, then the button honors the block\'s rows= value.' },
            'focusorder': {
               'Typecast': GTypecast.whole,
               'Description': 'TODO'},
            'label': {
               'Typecast': GTypecast.name,
               'Description': 'The text that should appear on the button' } },
##            'width': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The width of the entry in text columns.' },
##            'height': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The height of the entry in text rows. ' },
##            'x': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text column starting position of the widget. Based upon leftmost column of screen being 0.' },
##            'y': {
##               'Required': True,
##               'Typecast': GTypecast.whole,
##               'Description': 'The text row starting position of the widget. Based upon the top row of the screen being 0.' } },
         'Positionable': True,
         'ParentTags': ('page',),
         'Description': 'TODO' },

      'options': {
         'BaseClass': GFObjects.GFOptions,
         'UsableBySiblings': True,
         'ParentTags': ('form',),
         'Description': 'TODO' },

      'option': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Required': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'title': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'title': {} },
               'Default': 'title',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'Deprecated': 'Use the <form> attribute "title" instead.',
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'name': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'name': {} },
               'Default': 'name',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'author': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'author': {} },
               'Default': 'author',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'description':{
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'description': {} },
               'Default': 'description',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'version': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'version': {} },
               'Default': 'version',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },

      'tip': {
         'BaseClass': GFObjects.GFOption,
         'Attributes': {
            'name': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                   'tip': {} },
               'Default': 'tip',
               'Description': 'TODO' },
            'value': {
               'Typecast': GTypecast.text,
               'Description': 'TODO' } },
         'MixedContent': True,
         'SingleInstance': True,
         'ParentTags': ('options',),
         'Description': 'TODO' },
      'parameter':    {
         'BaseClass': GFObjects.GFParameter,
         'Attributes': {
            'name':          {
               'Required': True,
               'Unique': True,
               'Typecast': GTypecast.name,
               'Description': 'TODO' },
            'required':    {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'TODO' },
##            'limited':     {
##               'Typecast': GTypecast.boolean,
##               'Default': False,
##               'Description': 'TODO' },
            'default':     {
               'Typecast': GTypecast.text,
               'Description': 'TODO' },
            'description': {
##               'Required': True,
               'Typecast': GTypecast.text,
               'Description': 'TODO' },
##            'source':      {
##               'Typecast': GTypecast.name,
##               'Description': 'TODO' },
            'type':        {
               'Typecast': GTypecast.name,
               'Default': "char",
               'Description': 'TODO' } },
         'ParentTags':  ('form',),
         'Description': 'TODO' },
    }


    #
    # Create the dialog alias for the forms
    #
    copy._deepcopy_dispatch[types.FunctionType] = copy._deepcopy_atomic
    copy._deepcopy_dispatch[types.ClassType] = copy._deepcopy_atomic
    copy._deepcopy_dispatch[type(int)] = copy._deepcopy_atomic                            
    dialog=copy.deepcopy(xmlElements['form'])
    dialog['Required'] = False
    dialog['SingleInstance'] = False
    dialog['Importable'] = True
    dialog['Attributes']['style']['Default']='dialog'
    dialog['ParentTags']= ('form',)
    xmlElements.update({'dialog':dialog})


    #
    # Add DataSource elements
    #
    xmlElements.update(
      GDataSource.getXMLelements(
        updates={'datasource': {
                   'BaseClass': GFObjects.GFDataSource,
                   'ParentTags': ('form',) },
                 'cparam': {
                   'BaseClass': GFObjects.GFCParam }
                 }))


    #
    # Add trigger elements
    #
    xmlElements.update(
      GTrigger.getXMLelements(
        updates={'trigger':{
                   'ParentTags': ('form',)},
                }))

    #
    # Add menu elements
    #
    xmlElements.update(
        GMenu.getXMLelements(
                updates={'menu': {
                   ##'BaseClass': GFObjects.GFMenu,
                   'ParentTags': ('form',) },
                 }))

  return GParser.buildImportableTags('form',xmlElements)

#
# Different Types of Entries
#
entryStyles = {'text': 'Text Field',
               'dropdown': 'Drop Down Box',
               'label': 'Label-like Field',
               'checkbox': 'Check Box' }

#######################################################
#
# xmlFormsHandler
#
#######################################################

class xmlFormsHandler (GParser.xmlHandler): 
  """
  This class is called by the XML parser to
  process the .GFD file.
  """
  def __init__(self):
    

    GParser.xmlHandler.__init__(self)
    
    # This is a temp thing until we figure out
    # how to better do layout namespaces
    self.xmlNamespaceAttributesAsPrefixes = True

    self.xmlElements = getXMLelements()


