#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

import os
import sys
import string

import atexit

from gnue.forms.uidrivers._base import Exceptions

try:
  import curses
except ImportError:
  raise Exceptions.DriverNotSupported, _("The GNUe-Forms Curses driver requires Python 2.1+ and the ncurses library.")

from gnue.common.cursing import *

from gnue.common import events

from gnue.forms.GFForm import *

from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit
from gnue.forms.uidrivers.curses.GFsio import *
from gnue.forms.uidrivers.curses.common import _EVENTPROCESSOR

from gnue.common.apps import GDebug
from gnue.common.datasources import GLoginHandler
from gnue.common.utils.TextUtils import lineWrap

_NOTEBOOK = None
_EVENTPROCESSOR = None
global _EVENTPROCESSOR

#
# GFUserInterface
#
# The public interface to the User Interface
# All UIs must provide this class
#
class GFUserInterface(commonToolkit.GFUserInterface):

  _objectMapping = {}


  #
  # initialize
  #
  def initialize(self):

    global _EVENTPROCESSOR
    _EVENTPROCESSOR = self.dispatchEvent

    #
    # Create the main window
    #

    self._SIO = self._screen = GetSIO() # Must happen before the curses.termname() call
                                        # in the next line.
    GDebug.printMesg(1,'Initializing curses interface (TERM=%s)' % curses.termname())
    self._SIO.Cls()

    #
    # SplashScreen
    #
    if self._disableSplash:
      text = 'GNU Enterprise Forms\n' \
           + 'Version %s\n' % VERSION  \
           + '(c)2000-2004 Free Software Foundation\n' \
           + 'Protected by GNU General Public Licence 2.0\n'

    #MsgBoxOK(self.mainWindow, text).Show()

    self.widgetWidth = 1  # The width of a 1 char widget (for things like buttons)
    self.widgetHeight = 1 # The pixel height of a 1 char widget (for things like buttons)
    self.textWidth = 1    # The pixel width of text inside a widget
    self.textHeight = 1   # The pixel height of text inside a widget

    #self.mainWindow.panel = MyDialog(self.mainWindow, 0, 0, self._screen.MAXROW, self._screen.MAXCOL )

  #############################################################################
  #
  # Private UIBase support functions
  #
  # Called in UIbase functions to perform UI interaction with this specific
  # widget set.
  #

  #
  # _exit
  #
  # Tells the application to close it's main window
  #
  def _exit(self):
    self.mainWindow.EndScreenAccess()


  def _setStatusBar(self,*args):
    pass


  # Can be used by UI drivers to add more attributes to the creation event.
  def _updateCreateEvent(self, event):
    event.eventHandler = self.dispatchEvent
    event.ui = self
    event.formWidth = int(self._form._layout.Char__width)
    event.formHeight = int(self._form._layout.Char__height)
    event.screenHeight = self._screen.MAXROW - 3
    event.screenWidth = self._screen.MAXCOL
    return event


  #############################################################################
  #
  # Incoming Event Processors
  #
  # Processes the incoming events from other objects
  #

  #
  # mainLoop
  #
  # The primary loop of the user interface.  Called once the UI is
  # fully activated
  #
  def mainLoop(self):
    self._children[0].mainWindow.Run()
    pass


  #
  # gotoPage
  #
  # makes the requested page visible on the screen
  #
  def gotoPage(self, event):
    self.visiblePage.Hide()
    self.visiblePage = self._objectMapping[event.data]
    self.visiblePage.Show()

##     if not _NOTEBOOK:
##       self.visiblePage.Show(FALSE)
##       self.visiblePage = self._formToUI[event.data][0]
##       # TODO: move the calculatoin out of here
##       self.visiblePage.SetSize(wxSize(int(self._form.width)*int(self.widgetWidth),
##                                       int(int(self._form.height)+self.menu_sb_space)*int(self.widgetHeight)))
##     else:
##       self.visiblePage = self._formToUI[event.data][0]
##       for count in range(_NOTEBOOK.GetPageCount()):
##         if self.visiblePage.GetId() == _NOTEBOOK.GetPage(count).GetId():
##           _NOTEBOOK.SetSelection(count)
##           break
##     self.visiblePage.Show(1)

  #
  # formAlert
  #
  # Rings a bell and alters the statusbar to display
  # a line of text
  #
  def formAlert(self, event):
    curses.beep()
    curses.flash()


  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  def beginWait (self, event):
    pass


  # Called whenever forms leaves a "wait" state
  def endWait (self, event):
    pass


  #############################################################################
  #
  # Internal Event Processors
  #
  # Processes the events from the widget set
  #

  #
  # menuExitEvent
  #
  # Catches the Exit event from the menu and make sure it closes in such a way to
  # trigger the closeTrap method
  #
  def menuExitEvent(self, event):
    self.mainWindow.Close()

  #
  # promptForRecordNumber
  #
  # Presents a dialog to user asking for the record number to jump to
  #
  def promptForRecordNumber(self, event= None):
     pass


  #
  # closeTrap
  #
  # intercepts the applications closure and generates an event to the form requesting
  # closure.  Allows the form to control closure.  If the form approves it'll send
  # back an event closing the application
  #`
  def closeTrap(self,event):
    pass
##     object = _eventObjTowxWindow(event)
##     if event.CanVeto():
##       self.dispatchEvent(events.Event('requestEXIT'))
##     else:
##       object.Destroy()
