#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.common.cursing import *

from gnue.forms.uidrivers.curses.widgets._base import UIHelper

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    style = object.style
    if style == 'dropdown':
      if event.initialize:
        choices = object._field.allowedValues()[1]
      else:
        choices = [""]
      newWidget = ComboBox(event.container, 'name',object["Char:y"]+spacer,object["Char:x"], object["Char:width"])
      for index in range(len(choices)):
        newWidget.AddItem(index,choices[index])
    elif style == 'label':
      newWidget = TextBox(event.container, 'name', object["Char:y"]+spacer, object["Char:x"], object["Char:width"])
    elif style == 'checkbox':
      newWidget = CheckBox(event.container, 'name',object["Char:y"]+spacer,object["Char:x"],'',0)
    elif hasattr(object,'["Char:height"]') and object["Char:height"] > 1: # Normal text box/Multiline
      newWidget = TextArea(event.container, 'name', object["Char:y"]+spacer, object["Char:x"], object["Char:width"], object["Char:height"])
    else: # Normal text box
      newWidget = TextBox(event.container, 'name', object["Char:y"]+spacer, object["Char:x"], object["Char:width"])

    event.container.AddControl(newWidget)

    return newWidget

configuration = {
  'baseClass'  : UIEntry,
  'provides'   : 'GFEntry',
  'container'  : 0,
  }
