#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.common.apps import GDebug
from gnue.common.cursing import *
from gnue.forms.uidrivers.curses.widgets._base import UIHelper
from gnue.forms.uidrivers.curses.common import keyboardEvtHandler
from gnue.forms.uidrivers.curses.common import _EVENTPROCESSOR
global _EVENTPROCESSOR
#
# UIPage
#
# Widget set specific function that creates a single instance of a page
#
# Note: The event trap for changing notebook pages is attached to the UIForm
#
class UIPage(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    GDebug.printMesg(0, "PAGE OBJECT %s" % object)
    
    width = event.formWidth + 2
    height = event.formHeight + 2
    x = int(event.screenWidth/2 - width/2)
    y = int(event.screenHeight/2 - height/2)

    # For the menu bar
    if y < 2:
      y = 2
    # For sanity
    if x < 0:
      x = 0
    if y + height > event.screenHeight - 3:
      height = event.screenHeight - 3
    if x + width > event.screenWidth- 2:
      width = event.screenWidth


    newWidget = self._uiForm._wrapper.createPage(object)

    ###newWidget.DeActivate(0)
    ###event.interface._pageList.append(newWidget)
    event.interface._objectMapping[object] = newWidget
    event.interface._objectMapping[newWidget] = object

    ####
    global _EVENTPROCESSOR
    newWidget.KeystrokeHook = keyboardEvtHandler(_EVENTPROCESSOR)._processEvent
    self._containerToolkitWidget = newWidget

    return newWidget

configuration = {
  'baseClass'  : UIPage,
  'provides'   : 'GFPage',
  'container'  : 1,
  }
