#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/ErrorHandler.py
#
# DESCRIPTION:
# Standart Error and Exception handler
#
# NOTES:
#

import string, sys
import gtk

from gnue.common.utils.TextUtils import lineWrap

#from GFwxApp import getWxApp

def handleStartupError(errortext):
  print
  print '-' * 60
  print _("Error: %s") % errortext
  print '-' * 60

  print

  _StartupErrorDisplay(str(errortext))
  sys.exit()


def handleUncaughtException(extype, exvalue, traceback):
  # If we throw an exception, we don't want circular calls
  sys.excepthook = sys._orig_excepthook

  _ExceptionDisplay(extype, exvalue, traceback)

  # Restore exception handler
  sys.excepthook = handleUncaughtException


#
#
#
class _StartupErrorDisplay(gtk.MessageDialog):
  def __init__(self, errortext):
    message = _('Unable to start GNUe Forms:') + '\n\n %s' % errortext
    
    message = lineWrap(message,60)
    
    gtk.MessageDialog.__init__(self, None, gtk.DIALOG_MODAL|\
                               gtk.DIALOG_DESTROY_WITH_PARENT, \
                               gtk.MESSAGE_ERROR,\
                               gtk.BUTTONS_CLOSE, message)
    self.show_all()
    self.connect('response',lambda dialog, \
#                 response: self.destroy())
                 response: gtk.mainquit())

    gtk.main()


#
#
#
class _ExceptionDisplay(gtk.MessageDialog):
  def __init__(self, extype, exvalue, traceback):
    message = _('Exception occured in GNUe Forms:') + \
              '\n\n Type %s' % extype +\
              '\n Value %s' % exvalue 
    
    message = lineWrap(message,60)
    
    gtk.MessageDialog.__init__(self, None, gtk.DIALOG_MODAL|\
                               gtk.DIALOG_DESTROY_WITH_PARENT, \
                               gtk.MESSAGE_ERROR, \
                               gtk.BUTTONS_CLOSE, message)
    self.show_all()
    self.connect('response',lambda dialog, \
                 response: self.dialog.destroy())    

