#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/common.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
# TODO:
#  * add global accelerator maps
#  * cleanup event stuff


import string
import gtk,pango
from gnue.common import events
   
PANGO_SCALE = 1024 # where can I get that definition from?            

#####################################################################
##
## Basic Event Processing
##
#####################################################################

def _setDefaultEventHandlers(newWidget, eventHandler, initialize, uiDriver):
    if initialize:
        # Just care for keypresses which get not handled
        newWidget.connect_after("key-press-event", _keyPressHandler,\
                              uiDriver, eventHandler)

        #OLD: Mouse event stuff
        #newWidget.connect("button-press-event", _buttonPressHandler,\
        #                  uiDriver, eventHandler)
        return



#
# keyboardEvtHandler
#
# Traps most keypress events and translates them into
# GNUe events passed back to the form
#

# should be replaced by accelerators ONLY

def _keyPressHandler(widget, event, uiDriver, eventHandler):
    # just care for keypresses
    if event.type!=gtk.gdk.KEY_PRESS:
        return
    action = None
    keycode = event.keyval

    isShift = event.state and gtk.gdk.SHIFT_MASK
    isLock = event.state and gtk.gdk.LOCK_MASK
    isCtrl = event.state and gtk.gdk.CONTROL_MASK
    isMod1 = event.state and gtk.gdk.MOD1_MASK

    try:
        object = uiDriver._WidgetToGFObj[widget]
    except:
        return

    #
    # Sigh... a hack for using <enter> in multiline entries
    #
    if  keycode == gtk.keysyms.Return and \
        not event.state and \
        not isinstance(widget,gtk.TextView) and \
        int (gConfigForms('enterIsNewLine')) and \
        (hasattr(object,'Char__height') and object.Char__height) > 1:

      command = 'NEWLINE'

    else:


      #
      # Get the event to process from the KeyMapper
      #
      command = GFKeyMapper.KeyMapper.getEvent(
        keycode,
        isShift,
        isCtrl,
        isMod1)

    if command == 'JUMPRECORD':
      global _PROMPTFORRECORD
      action = _PROMPTFORRECORD()

    elif command == 'NEWLINE':
      action = events.Event('requestKEYPRESS', '\n',
                     text='\n',
                     code=10)

    elif command:
      action = events.Event('request%s' % command)

    elif object._type == 'GFButton':
      action = events.Event('buttonActivated',object)

    elif object.style == 'checkbox' and object._type == 'GFEntry':
      # <space> <=> <click>
      if keycode == gtk.keysyms.Space:
          action = events.Event('requestTOGGLECHKBOX')
      else:
          # maybe some background error message here
          pass
##     elif not event.state: # no special modifier keys pressed
##       try:
##         char = chr(keycode)
##         if char in string.printable or char == "\n" or \
##            128 <= keycode <= 255:
##           action = events.Event('requestKEYPRESS', char,
##                          text=char,
##                          code=keycode)
##       except ValueError:
##         pass 
      

#   print "'%s'" % command
##     if command in ('CURSORLEFT', 'CURSORRIGHT','NEXTRECORD', 'PREVRECORD',
##                    'BACKSPACE','DELETE','SELECTLEFT','SELECTRIGHT') and \
##                     isinstance(widget,gtk.Entry):
##         print 'stopped'
##         action=0

    if action:
      # Add the object's _form to the outgoing event
      # rather than every event in the function
      action.__dict__.update({'_form':object._form})
      eventHandler(action)
      return gtk.TRUE       
        	
#
# mouseEvtHandler
#
# Traps most mouse events and translates them into
# GNUe events passed back to the form
#
    
def _buttonPressHandler(widget, event, uiDriver, eventHandler):
    if (event.type!=gtk.gdk.BUTTON_PRESS and \
        event.type!=gtk.gdk._2BUTTON_PRESS):
        return
    action = None

    isShift = event.state and gtk.gdk.SHIFT_MASK
    isLock = event.state and gtk.gdk.LOCK_MASK
    isCtrl = event.state and gtk.gdk.CONTROL_MASK
    isMod1 = event.state and gtk.gdk.MOD1_MASK

    try:
        object = uiDriver._WidgetToGFObj[widget]
    except:
        object = uiDriver._WidgetToGFObj[widget._parent]

    #
    #  Focus
    #
    if event.button==1:
        if isinstance(widget,gtk.Entry):
            pangoLayout = widget.get_layout()
            (offset_x,offset_y) = widget.get_layout_offsets()
            (cursor_x,cursor_y) = pangoLayout.xy_to_index((event.x-offset_x) \
                                                          *PANGO_SCALE,
                                                          (event.y-offset_y)\
                                                          *PANGO_SCALE)
            # print '%s,%s -> %s' % (event.x,event.y,cursor_x)
            eventHandler('requestFOCUS',object,_form=object._form)
            eventHandler('requestCURSORMOVE',position=cursor_x+1,\
                         _form=object._form)
            return gtk.TRUE
        
        if isinstance(widget,gtk.TextView):
            (cursor_x,cursor_y) = widget.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET,
                                                                 event.x,
                                                                 event.y)
            iter = widget.get_iter_at_location(cursor_x,cursor_y)
            cursor_ofs = iter.get_offset()
            # print '%s,%s -> %s' % (event.x,event.y,cursor_ofs)
            eventHandler('requestFOCUS',object,_form=object._form)
            eventHandler('requestCURSORMOVE',position=cursor_ofs, \
                         _form=object._form)
            return gtk.TRUE

                                                             
#####################################################################
##
## Keymapper Support
##
#####################################################################

# TODO: Check if we can/want to take over global key maps (like gnome keymap)

from gnue.forms import GFKeyMapper
from gnue.forms.GFKeyMapper import vk

# Translate from wx keystrokes to our virtual keystrokes
gtkKeyTranslations = {
   vk.F1     :gtk.keysyms.F1,        vk.F2        :gtk.keysyms.F2,
   vk.F3     :gtk.keysyms.F3,        vk.F4        :gtk.keysyms.F4,
   vk.F5     :gtk.keysyms.F5,        vk.F6        :gtk.keysyms.F6,
   vk.F7     :gtk.keysyms.F7,        vk.F8        :gtk.keysyms.F8,
   vk.F9     :gtk.keysyms.F9,        vk.F10       :gtk.keysyms.F10,
   vk.F11    :gtk.keysyms.F11,       vk.F12       :gtk.keysyms.F12,
   vk.INSERT :gtk.keysyms.Insert,    vk.DELETE    :gtk.keysyms.Delete,
   vk.HOME   :gtk.keysyms.Home,      vk.END       :gtk.keysyms.End,
   vk.PAGEUP :gtk.keysyms.Prior,     vk.PAGEDOWN  :gtk.keysyms.Next,
   vk.UP     :gtk.keysyms.Up,        vk.DOWN      :gtk.keysyms.Down,
   vk.LEFT   :gtk.keysyms.Left,      vk.RIGHT     :gtk.keysyms.Right,
   vk.TAB    :gtk.keysyms.Tab,
   vk.ENTER  :gtk.keysyms.Return,    vk.BACKSPACE :gtk.keysyms.BackSpace }

GFKeyMapper.KeyMapper.setUIKeyMap(gtkKeyTranslations)


      
