#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/box.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
import gtk
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

#
# UIBox
#
# Widget set specific function that creates a single instance of a border box
#
class UIBox(UIHelper):
    
  def _createWidget(self, event, spacer):
    object = event.object
    
    newWidget = gtk.Frame()
    newWidget.set_size_request(int(self.itemWidth - (1 * event.widgetWidth)),
                               int(self.itemHeight - (0.5 * event.widgetHeight)))
    
    newWidget.set_label(object.label)
    newWidget.get_label_widget().modify_font(self._uiDriver.mono_font)

    event.container.put(newWidget,
                        int((object.Char__x+0.5) * event.widgetWidth),
                        int((object.Char__y + spacer + 0.5) * event.widgetHeight))
    return newWidget

#
# Configuration data 
#
configuration = {
    'baseClass'  : UIBox,
    'provides'   : 'GFBox',
    'container'  : 0,
    }

