#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/entry.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
# TODO:
#  * fix "selection" for gtk.entry
#  * fix position to byteindex conversion (UTF-8)
#       Update: working for Unicode Strings, i.e. when using Unicode as
#               internal data representation has to be unicode, which is
#               postponed for > ver. 0.5.1
#

import gtk
from gnue.common import events
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper
from gnue.common.apps import GDebug

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    style = object.style

    if style == 'dropdown':
      if event.initialize:
        self.choices = object._field.allowedValues()[1]
      else:
        self.choices = [""]

      # should we add this to the wx driver as well?
      self.choices.sort()

      newWidget = gtk.Combo()
      newWidget.set_popdown_strings(self.choices)

      newWidget.set_size_request(self.itemWidth, self.itemHeight)
      event.container.put(newWidget, object.Char__x * event.widgetWidth,
                          (object.Char__y + spacer + (object._gap * spacer)) \
                          * event.widgetHeight)

      newWidget.list.connect('select-child', self.comboHandler, newWidget)

      if event.initialize:
        newWidget._origAllowedValues = object._field._allowedValues
        self._addDefaultEventHandler(newWidget.entry, event.eventHandler, \
                                     self._uiDriver)
        self._addDefaultEventHandler(newWidget.list,  event.eventHandler, \
                                     self._uiDriver)


    elif style == 'label':
      newWidget = gtk.Label("")
      newWidget.set_size_request(self.itemWidth, self.itemHeight + 1)
      event.container.put(newWidget, object.Char__x * event.widgetWidth,
                          (object.Char__y + spacer + (object._gap * spacer))\
                          * event.widgetHeight)

    elif style == 'checkbox':
      newWidget = gtk.CheckButton(object.label)
      newWidget.set_size_request(self.itemWidth, event.textHeight)
      event.container.put(newWidget, object.Char__x * event.widgetWidth,
        (object.Char__y + spacer + (object._gap * spacer)) * event.widgetHeight)
      newWidget._clicked_handler = newWidget.connect('clicked', self.checkboxHandler, newWidget)
      if event.initialize:
        self._addDefaultEventHandler(newWidget, event.eventHandler,\
                                     self._uiDriver)

    else:
      value=""
      if hasattr(object,'Char__height') and object.Char__height>1:
        newWidget = MultiLineEdit(value, event.eventHandler,self._uiDriver)
        viewport = newWidget.viewport
      else:
        newWidget=viewport=gtk.Entry()
        newWidget._insert_handler = newWidget.connect('insert-text', \
                                                      self.insertTextHandler,\
                                                      event.eventHandler, \
                                                      self._uiDriver)

        newWidget._delete_handler = newWidget.connect('delete-text',\
                                                      self.deleteTextHandler,\
                                                      event.eventHandler,\
                                                      self._uiDriver)

      viewport.set_size_request(self.itemWidth, self.itemHeight+1)
      event.container.put(viewport, object.Char__x * event.widgetWidth,
                          (object.Char__y + spacer + (object._gap * spacer))\
                          * event.widgetHeight)
      if event.initialize:
        self._addDefaultEventHandler(newWidget, event.eventHandler,\
                                     self._uiDriver)

    self._eventHandler = event.eventHandler
    event.container.show_all()
    return newWidget


  def setCursorPosition(self, position, index=0):
    widget=self.widgets[index]
    if isinstance(widget,gtk.Entry) or isinstance(widget,MultiLineEdit):
      widget.set_position(position)
    else:
      print _("Wrong Place to execute set CursorPosition (%s,%s), widget is a %s") % (position,index,widget)

  def setSelectedArea(self, selection1, selection2, index=0):
    widget=self.widgets[index]
    if isinstance(widget,gtk.Entry):
      widget.select_region(selection1, selection2)
    elif  isinstance(widget,gtk.TextView):
      widget.get_buffer().select_region(position)

  ###########################################################
  #
  #  Internal Event Handler
  #
  #

  #
  #  eventHandler for gtk.Entry, interrupts default insertText procedure and
  #  passes the text to the normal displayhandler
  #

  def insertTextHandler(self,widget,newtext,length,position,eventHandler,uiDriver):
    #print "insert '%s' at %s" % (newtext,widget.get_position())
    if isinstance(widget,gtk.TextBuffer):
      object=uiDriver._WidgetToGFObj[widget._textview]
      object._displayHandler.cursor = widget.get_insert()

    else:
      object=uiDriver._WidgetToGFObj[widget]
      object._displayHandler.cursor = widget.get_position()
    # HACK: set the cursor position for display handler
    #       this should be passed with the event

    # Compatibility layer for 0.5.1
    #text = unicode(newtext,'utf-8')
    text = unicode(newtext,'utf-8').encode(gConfigForms('textEncoding'))

    action = events.Event('requestKEYPRESS', text, text=text,
                          code=0, _form=object._form)

    # don't process event further
    widget.emit_stop_by_name('insert-text')

    gtk.idle_add(eventHandler,action)  # our eventHandler will be called later

  #
  #  eventHandler for gtk.Entry, interrupts default deleteText procedure,
  #  passes event to displayhandler in two parts (1. selection, 2. delete)
  #

  def deleteTextHandler(self,widget,start_pos,end_pos,eventHandler,uiDriver):
    #print "delete (%s..%s)" % (start_pos,end_pos)
    object=uiDriver._WidgetToGFObj[widget]

    # HACK:
    # it should be possible to possible to pass the area to be deleted
    # with the gnue internal event.
    #object._displayHandler.selection1=start_pos
    #object._displayHandler.selection2=end_pos
    #object._displayHandler.cursor = widget.get_position()
    #action = events.Event('requestDELETE',
    try:
      CursorPos = widget.get_position()
    except:
      CursorPos = widget.get_insert()

    action = events.Event('requestDELETERANGE',
                          start_pos=start_pos,
                          end_pos=end_pos,
                          position=CursorPos,
                          _form=object._form)

    widget.emit_stop_by_name('delete-text')
    gtk.idle_add(eventHandler,action)

  #
  #  eventHandler for gtk.Combo,  no interruption, etc.
  #

  def comboHandler(self, combo_list, list_child, combo):
    selection = combo_list.child_position(list_child)
    selected_text = self.choices[selection]

    gfObject     = self._uiDriver._WidgetToGFObj[combo]
    eventdata = [gfObject, selected_text]
    action = events.Event('requestREPLACEVALUE',object=gfObject,
                          index=selection, text=selected_text,
                          _form=gfObject._form)

    # TODO: allow veto
    self._eventHandler(action)

    return gtk.TRUE

  #
  #  eventHandler for gtk.CheckBox,  no interruption, etc.
  #

  def checkboxHandler(self,event,widget):
    buttonStatus=widget.get_active()
    GDebug.printMesg(1, "buttonStatus: " + str(buttonStatus))
    gfObject     = self._uiDriver._WidgetToGFObj[widget]
    eventdata = [gfObject, buttonStatus]
    action = events.Event('requestTOGGLECHKBOX', _form=gfObject._form)
    # don't process event further
    widget.emit_stop_by_name('clicked') # FIXME: won't accept veto
    widget.emit_stop_by_name('released') # FIXME: won't accept veto

    #gtk.idle_add(self._eventHandler,action)  # our eventHandler will be called later
    return gtk.TRUE


# TODO: Add support for READONLY edits with: set_editable

class MultiLineEdit:
  def __init__(self,value,eventHandler,uiDriver):
    self.textTagTable=gtk.TextTagTable()
    self.textBuffer=gtk.TextBuffer(self.textTagTable)
    self.baseWidget=gtk.TextView()
    self.baseWidget.set_buffer(self.textBuffer)
    self.baseWidget.set_wrap_mode(gtk.WRAP_CHAR)
    self.baseWidget._parent=self
    self.textBuffer.set_text(value)
    self.viewport=gtk.ScrolledWindow()
    self.viewport.add_with_viewport(self.baseWidget)
    self.viewport.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

    self.insert_handler = self.textBuffer.connect('insert-text', \
                                             self.insertTextHandler,\
                                             eventHandler, \
                                             uiDriver)

    self.delete_handler = self.textBuffer.connect('delete-range',\
                                             self.deleteTextHandler,\
                                             eventHandler,\
                                             uiDriver)

    self.mv_cur_handler = self.baseWidget.connect('move-cursor',\
                                             self.moveCursorHandler,\
                                             eventHandler,\
                                             uiDriver)

  # Return own name to let other objects identify this obj.
  def get_name(self):
    return 'MultiLineEdit'

  def set_position(self,position):
    try:
      self.baseWidget.handler_block(self.mv_cur_handler)
    except:
      pass
    pos_iter = self.textBuffer.get_iter_at_offset(position)
    self.textBuffer.place_cursor(pos_iter)
    print position
    # take care that the cursor is visible
    cur_mark = self.textBuffer.get_insert()
    self.baseWidget.scroll_mark_onscreen(cur_mark)
    #print "SCROLLED TO ", cur_mark
    try:
      self.baseWidget.handler_unblock(self.mv_cur_handler)
    except:
      pass

  def set_text(self,value):
    try:
      self.textBuffer.handler_block(self.insert_handler)
      self.textBuffer.handler_block(self.delete_handler)
    except:
      pass
    self.textBuffer.set_text(value)
    #print "settext"
    try:
      self.textBuffer.handler_unblock(self.insert_handler)
      self.textBuffer.handler_unblock(self.delete_handler)
    except:
      pass

  # pass through function calls
  def __getattr__(self, attr):
    #print "doing %s" % attr
    if self.baseWidget and attr[1] != '_' and hasattr(self.baseWidget,attr):
      return getattr(self.baseWidget,attr)
    else:
      raise AttributeError, attr


  def insertTextHandler(self,widget,textiter,newtext,position,eventHandler,uiDriver):
    #print "insertText %s " % newtext
    object=uiDriver._WidgetToGFObj[self]
#    object._displayHandler.cursor = widget.get_insert()
    object._displayHandler.cursor = textiter.get_offset()

    # Compatibility layer for 0.5.1
    #text = unicode(newtext,'utf-8')
    text = unicode(newtext,'utf-8').encode(gConfigForms('textEncoding'))

    action = events.Event('requestKEYPRESS', text, text=text,
                          code=0, _form=object._form)

    # don't process event further
    widget.emit_stop_by_name('insert-text')

    gtk.idle_add(eventHandler,action)  # our eventHandler will be called later


  def deleteTextHandler(self,widget,start_pos,end_pos,eventHandler,uiDriver):
    #print "delete (%s..%s)" % (start_pos.get_offset(),end_pos.get_offset())

    object=uiDriver._WidgetToGFObj[self]

    cursor_iter = widget.get_iter_at_mark(widget.get_insert())


    action = events.Event('requestDELETERANGE',
                          start_pos=start_pos.get_offset(),
                          end_pos=end_pos.get_offset(),
                          position=cursor_iter.get_offset(),
                          _form=object._form)

    widget.emit_stop_by_name('delete-range')
    gtk.idle_add(eventHandler,action)

  def moveCursorHandler(self,widget,arg1,arg2,arg3,eventHandler,uiDriver):
    print "move Cursor (%s,%s,%s)" % (arg1,arg2,arg3)
    #arg1: movement type (1 = horizontal, 3 = vertikal)
    #arg2: offset: +/- relative movement
    object=uiDriver._WidgetToGFObj[self]

    return
    cursor_iter = widget.get_iter_at_mark(widget.get_insert())


    action = events.Event('requestDELETERANGE',
                          start_pos=start_pos.get_offset(),
                          end_pos=end_pos.get_offset(),
                          position=cursor_iter.get_offset(),
                          _form=object._form)

    widget.emit_stop_by_name('delete-range')
    gtk.idle_add(eventHandler,action)



configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
