#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/forms/wrappers.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import string, sys
import gtk
from gnue.common import events
from gnue.common.apps import GDebug

from gnue.forms.uidrivers.gtk2.common import *

class ScrollableWrapper(gtk.ScrolledWindow):
  def __init__(self, uiform):
 
    self.uiform = uiform
    self.frame = frame = uiform.containerFrame
    self.form = form = uiform._form
    self.margin = 2
    gtk.ScrolledWindow.__init__(self)
    self.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    #self.set_border_width(self.margin)
    self.frame.add(self)

    formWidth = int(form._layout.Char__width)
    formHeight = int(form._layout.Char__height)
    self.layoutXSize = formWidth*uiform._uiDriver.widgetWidth
    self.layoutYSize = formHeight*uiform._uiDriver.widgetHeight
    
    self._fitted = 0
    self._pageList = []

  def finalize(self):
    pass

#
# Notebook pages
#
class TabbedWrapper(gtk.Notebook):
  def __init__(self, uiform):
#    ScrollableWrapper.__init__(self, *args, **parms)
    self.uiform = uiform
    self.frame = frame = uiform.containerFrame
    self.pane = self
    self.margin = 2
    gtk.Notebook.__init__(self)
    try:
      tabstyle  = _tabStyles[self.form._layout.tabbed]
      self.set_tab_pos(tabstyle)
    except:
      pass
    self.set_scrollable(gtk.TRUE)
    # The signal "select-page" doesn't work with 
    # self.connect('select-page', self.notebookTabHandler)
    self.connect('switch-page', self.notebookTabHandler)

    self.frame.add(self)

    self.form = form = uiform._form
    formWidth = int(form._layout.Char__width)
    formHeight = int(form._layout.Char__height)
    self.layoutXSize = formWidth*uiform._uiDriver.widgetWidth
    self.layoutYSize = formHeight*uiform._uiDriver.widgetHeight

    self._oldpage=0
    self._pageList = []

    self.__notebookLoopTrap = 0

  def createPage(self, object):

    swin = gtk.ScrolledWindow()
    newWidget = gtk.Fixed()    
    tab_label=gtk.Label(object.name)

    swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    swin.add_with_viewport(newWidget)
    self.append_page(swin, tab_label)

    self._pageList.append(newWidget)
    # newWidget.set_size_request(self.layoutXSize,self.layoutYSize)

    return newWidget

  def finalize(self):
    self.pane.set_size_request(self.layoutXSize,self.layoutYSize)
    

  def notebookTabHandler(self,notebook,notebookpage,page_number):
    if self._oldpage!=page_number:
      
      action = events.Event('requestPAGE',page_number, _form=self.form)
      self.uiform._eventHandler(action)

      notebook.emit_stop_by_name('switch-page')

  def setPage(self, page):
    # get Scroll Window for page
    swin=page.get_parent().get_parent()
    page_number=self.page_num(swin)
    self._oldpage=page_number
    self.set_current_page(page_number)



#
# Single pages
#
class PlainWrapper(ScrollableWrapper):
  def __init__(self, *args, **parms):
    ScrollableWrapper.__init__(self, *args, **parms)
    self.pane = gtk.Fixed()
    self.add_with_viewport(self.pane)
    self.set_size_request(self.layoutXSize,self.layoutYSize)
    
  def finalize(self):
    self.pane.set_size_request(self.layoutXSize,self.layoutYSize)

  def createPage(self, object):
    newWidget = gtk.Fixed()
    self.pane.add(newWidget)

    # Only show first page
    if len(self._pageList)<1:
      newWidget.show_all()
      
    self._pageList.append(newWidget)
    return newWidget
  
  def setPage(self, page):    
    for p in self._pageList:
      if p != page:
        p.show_all()
      else:
        p.hide()

        
_tabStyles = {'left':gtk.POS_LEFT,
              'right':gtk.POS_RIGHT,
              'bottom':gtk.POS_BOTTOM,
              'top':gtk.POS_TOP,
              }

