#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/page.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import gtk

from gnue.forms.uidrivers.gtk2.common import _setDefaultEventHandlers

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper


#
# UIPage
#
# Widget set specific function that creates a single instance of a page
#
# Note: The event trap for changing notebook pages is attached to the UIForm
#
class UIPage(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    newWidget = self._uiForm._wrapper.createPage(object)  

    # _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize, self._uiDriver)

    # event.interface._pageList.append(newWidget)
    self._containerToolkitWidget = newWidget
    return newWidget
    

configuration = {
    'baseClass'  : UIPage,
    'provides'   : 'GFPage',
    'container'  : 1,
    }
