#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# SplashScreen.py
#
# DESCRIPTION:
"""
A QT based splash screen
"""
# NOTES:
#

## FIXME ##

from qt import *
from gnue.common.apps import GConfig
from gnue.forms import VERSION

class QTSplashScreen: ###(SplashScreen):
  def __init__(self):
    return

    images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'
    bitmapFile=images_dir+gConfigForms('splashScreenPNG')

    SplashScreen.__init__(self,None,bitmapfile=bitmapFile,
                          duration = 3000, callback=self.onCloseSplash,
                          style=wxCENTRE_ON_SCREEN|wxSIMPLE_BORDER|wxSTAY_ON_TOP
                          ) # TODO: A 2.4 thing? -> wxSPLASH_TIMEOUT|wxFRAME_NO_TASKBAR)
    swidth,sheight = self.GetSizeTuple()

    # Make the splash text print white
    self.SetForegroundColour(wxColour(0xFF, 0xFF, 0xFF))
    self.SetFont(wxFont(20,wxSWISS,wxNORMAL,wxBOLD))

    text = _("GNU Enterprise Forms")
    twidth,theight = self.GetTextExtent(text)
    wxStaticText(parent=self, id=-1, label=str(text),
                 size=wxSize(swidth,theight),pos=wxPoint(1,1),style=wxALIGN_CENTRE)

    self.SetFont(wxFont(10,wxSWISS,wxNORMAL,wxBOLD))

    text = _("Version %s") % VERSION
    twidth,theight = self.GetTextExtent(text)
    wxStaticText(parent=self, id=-1, label=str(text),
                 size=wxSize(swidth,theight), pos=wxPoint(1,25),style=wxALIGN_CENTRE)

    text = "(c)2000-2004 Free Software Foundation"
    twidth,theight = self.GetTextExtent(text)
    wxStaticText(self, -1, str(text),
                 wxPoint(1,50),wxSize(swidth,theight),wxALIGN_CENTRE)

    text = _("Protected by GNU General Public Licence 2.0")
    wxStaticText(self, -1, str(text),
                 wxPoint(1,sheight-(theight+10)),wxSize(swidth-5,theight),wxALIGN_RIGHT)

    self.CenterOnScreen()
    self.Show(true)

  #
  # onCloseSplash
  #
  # Called by SplashScreen when timer expires
  #
  # If the splashscreen has timed out before the form is
  # ready then go ahead and display what we've got.  This
  # is a desperate attempt to eliminate the vile
  #
  # Gdk-ERROR **: BadWindow (invalid Window parameter)
  #  serial 1228 error_code 3 request_code 15 minor_code 0
  #
  # on heavily loaded machines.  The key line seems to be
  # wxYield() but I'm leaving the others there because I
  # can :P  The fix works for me all the way down to a
  # splash duration=1 millisecond
  #
  def onCloseSplash(self):
    #self._wxapp.SetTopWindow(self.mainWindow)  #TODO: May need to put back but doubt it
    #self.mainWindow.Show(true)                 #TODO: May need to put back but doubt it
    wxYield() # Flush the pending queue to insure something is
              # there before the splashscreen dies

    # For some reason, a simple Close() doesn't cooperate with
    # the modal login box and all hell breaks loose
    self.Show(0)
    self.Destroy()

