#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A QT-based user interface driver for GNUe forms.
#
# NOTES:
#
import string

from qt import *
from gnue.common import events
from gnue.forms.uidrivers.qt.common import *
from gnue.forms.uidrivers.qt.common import _eventObjToQtWindow
from gnue.forms.uidrivers.qt.widgets._base import UIHelper
from gnue.forms.uidrivers.qt.MenuBar import MenuBar
from gnue.forms.uidrivers.qt.ToolBar import ToolBar

import wrappers

#
# UIForm
#
# Widget set specific function that creates a single instance of a Form widget
#
class UIForm(UIHelper):

  def __init__(self, event):
    self._uiPageList=[]
    UIHelper.__init__(self, event)


  def _createWidget(self, event, spacer):
    object = event.object

    #
    # Size based upon the form definition
    #
    self.menu_sb_space = 0

    formWidth = int(self._form._layout.Char__width)
    formHeight = int(self._form._layout.Char__height)
    self._visibleSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)

    self._formSize = formSize = (formWidth*self._uiDriver.widgetWidth,
                      (formHeight+self.menu_sb_space)*self._uiDriver.widgetHeight)


    # The main frame of this form
    if self._form.style != 'dialog':
      self.mainWindow = QMainWindow()
      # The status bar
      self.statusBar = self.mainWindow.statusBar()
      self.statusFields = []
      for i in range(5):
        w = QLabel(self.statusBar,"%s" % i)
        self.statusFields.append(w)
        self.statusBar.addWidget(w, not i, 1)
    else:
      self.mainWindow = QDialog(None, "w00t", 1)

    self.mainWindow.setCaption(str(self._form.title))


##    self.statusBar.SetStatusWidths([-1,50,50,75,75])

    # The window in which pages will be rendered
    if object._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper(self)
    else:
      self._wrapper = wrappers.PlainWrapper(self)

    newWidget = self._wrapper.pane
##    self._uiDriver._disabledColour = newWidget.paletteBackgroundColor()
    self._containerToolkitWidget = newWidget


    # Add the menu
    if not self._form._features['GUI:MENUBAR:SUPPRESS']:
      MenuBar(self._uiDriver, self.mainWindow, self._form)

    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar(self._uiDriver, self.mainWindow, self._form)


    self._eventHandler = event.eventHandler
    self._wrapper.finalize()

    return newWidget


  #
  # closeTrap
  #
  # intercepts the applications closure and generates an event to the form requesting
  # closure.  Allows the form to control closure.  If the form approves it'll send
  # back an event closing the application
  #`
  def closeTrap(self,event):
    form = self._form

    if event.CanVeto():
      self._uiDriver.dispatchEvent('requestEXIT',_form=self._form)
    else:
      object = _eventObjToQtWindow(event)
      object.Destroy()
      # wxExit() TODO: Try and work this into navigator or here if it still hangs


  #
  # gotoPage
  #
  # Makes the requested page visible while hiding the others
  #
  def gotoPage(self,event):
    self._wrapper.setPage(self._uiDriver._gfObjToUIWidget[event.data].widgets[0])

##    if not self._notebook:
##      for page in self._uiPageList:
##        if page != uiPage:
##          page.hide()
##        else:
##          page.show()
##    else:
##      # uiPage widgets only contain 1 item
##
##      pageId = uiPage.widgets[0].GetId()
##
##      for count in range(self._notebook.GetPageCount()):
##        if pageId == self._notebook.GetPage(count).GetId():
##          self._notebook.SetSelection(count)


  #
  # _setStatusBar
  #
  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord, maxRecord, currentPage, maxPage):

    # Popup forms don't seem to have a statusbar
    try:
      self.statusFields
    except AttributeError:
      return

    if tip != None: self.statusFields[0].setText(tip)

    if statusValue:
      self.statusFields[1].setText(statusValue)

    if insertValue:
      self.statusFields[2].setText(insertValue)

    if currentRecord and  maxRecord:
      self.statusFields[3].setText(string.strip("%s/%s" % (currentRecord,maxRecord)))

    if currentPage and  maxPage:
      self.statusFields[3].setText((string.strip("%s/%s" % (currentPage,maxPage))))

    #### TODO #####
    return
    #### TODO #####


    #
    # Adjust the status fields to reflect width of text in them
    #
    # This is a hack
    #
    tipWidth = -1 # Fill whatever remains
    statusWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(1))
    insertWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(2))
    recordWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(3))
    pageWidth,unused = self.statusBar.GetTextExtent(self.statusBar.GetStatusText(4))

    # Either double the width if it's set or default to 5
    statusWidth = statusWidth and (statusWidth * 2) or 5
    insertWidth = insertWidth and (insertWidth * 2) or 5
    recordWidth = recordWidth and (recordWidth * 2) or 5
    pageWidth   = pageWidth   and (pageWidth   * 2) or 5

    self.statusBar.SetStatusWidths([tipWidth,statusWidth,insertWidth,recordWidth,pageWidth])


  def show(self):
    #self.containerFrame.Show()
    self.mainWindow.show()

  def showModal(self):
    #self.containerFrame.Show()
    self.mainWindow.exec_loop()


