#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# uidriver/wx/common.py
#
# DESCRIPTION:
"""
Common Font and Event Handler routines
Part of a wxPython based user interface driver for GNUe forms.
"""
# NOTES:
#

import string
from types import UnicodeType, StringType
from wxPython.wx import *
from gnue.common import events
from gnue.common.apps import GDebug

# Finishing creation of dictionary for language font encodings
encodings = {
    'iso8859-1': wxFONTENCODING_ISO8859_1,
    'iso8859-2': wxFONTENCODING_ISO8859_2,
    'iso8859-3': wxFONTENCODING_ISO8859_3,
    'iso8859-4': wxFONTENCODING_ISO8859_4,
    'iso8859-5': wxFONTENCODING_ISO8859_5,
    'iso8859-6': wxFONTENCODING_ISO8859_6,
    'iso8859-7': wxFONTENCODING_ISO8859_7,
    'iso8859-8': wxFONTENCODING_ISO8859_8,
    'iso8859-9': wxFONTENCODING_ISO8859_9,
    'iso8859-10': wxFONTENCODING_ISO8859_10,
    'iso8859-11': wxFONTENCODING_ISO8859_11,
    'iso8859-12': wxFONTENCODING_ISO8859_12,
    'iso8859-13': wxFONTENCODING_ISO8859_13,
    'iso8859-14': wxFONTENCODING_ISO8859_14,
    'iso8859-15': wxFONTENCODING_ISO8859_15,
    'koi8': wxFONTENCODING_KOI8,
    'koi8-r': wxFONTENCODING_KOI8,
    'cp1250': wxFONTENCODING_CP1250,
    'cp1251': wxFONTENCODING_CP1251,
    'cp1252': wxFONTENCODING_CP1252,
    }

# adding encodings just found in newer wxWidgets versions
try:
    encodings.update({
        # 'utf-8': wxFONTENCODING_UTF8,
        'big5': wxFONTENCODING_BIG5,
        'gb2312': wxFONTENCODING_GB2312
        })
except NameError:
    pass
    

# hack for wxPython 2.2 (2.3+ doesn't need this)
def _eventObjTowxWindow(event):
    eo = event.GetEventObject()
    return wxPyTypeCast(eo, 'wxWindow')
    

#
# Little global helper routine to set font according to options
#
# TODO: Not completed
#
_pointSize = 0

def getPointSize():
  return _pointSize or setPointSize(gConfigForms('pointSize'))

def setPointSize(size):
  global _pointSize
  _pointSize = size
  return size

def initFont(widget, affectsLayout=1):
    if gConfigForms('fixedWidthFont'):
        try:
          enc=encodings[gConfigForms('textEncoding')]
	except:
	  GDebug.printMesg(1,_('Encoding %s is not supported by the wx UI driver') %\
	                       gConfigForms('textEncoding'))
	  enc=encodings['iso8859-1']
        widget.SetFont(wxFont(getPointSize(),wxMODERN,wxNORMAL,\
                              wxNORMAL,FALSE,'',enc))


def wxEncode(u_string):    
    if type(u_string)==UnicodeType:
        return u_string.encode(gConfig('textEncoding'),'replace')
    else:
        return u_string

def wxDecode(string):    
    if type(string)==StringType:
        return unicode(string, gConfig('textEncoding'))
    else:
        return string

#####################################################################
##
## Basic Event Processing
##
#####################################################################

def _setDefaultEventHandlers(newWidget, eventHandler, initialize, uiDriver):
    if initialize:
        # TODO: this should use one instance
        newWidget.PushEventHandler(mouseEvtHandler(eventHandler,uiDriver))
        newWidget.PushEventHandler(keyboardEvtHandler(eventHandler,uiDriver))
        
class uiBaseEvtHandler(wxEvtHandler):
    def __init__(self,eventList,eventProcessor, uiDriver):
        wxEvtHandler.__init__(self)
        self._eventProcessor = eventProcessor
        self._uiDriver = uiDriver
        for eventType in eventList:
            self.Connect(-1, -1, eventType,self._processEvent)
        

    def _processEvent(self,event):
        GDebug.printMesg(0,"uiBaseEvtHandler _processEvent was called?!?")
	
#
# mouseEvtHandler
#
# Traps most mouse events and translates them into
# GNUe events passed back to the form
#
class mouseEvtHandler(uiBaseEvtHandler):
  def __init__(self,eventProcessor, uiDriver):
    eventList = [wxEVT_LEFT_DOWN]
    uiBaseEvtHandler.__init__(self, eventList, eventProcessor, uiDriver)

  #
  # The putzing about with the event timestamp is to
  # allow us to process mouse click events twice. 
  # The mouse handler is called before the cursor 
  # position is updated so GetInsertionPoint returns 
  # the position from the widget losing focus.
  # setting the timestamp to zero is a flag to prevent
  # infinate loops and allow us to avoid process that does 
  # not need done twice.

  def _processEvent(self,event):
    object = _eventObjTowxWindow(event)

    id = object.GetId()
    gfObject     = self._uiDriver._IdToGFObj[id]
    screenWidget = self._uiDriver._IdToTkObj[id]
    count        = self._uiDriver._IdToUIObj[id].widgets.index(screenWidget)

    if event.GetTimestamp():
      self._eventProcessor('requestFOCUS',gfObject,_form=gfObject._form)
      self._eventProcessor('requestJUMPRECORD',count - gfObject._visibleIndex,_form=gfObject._form)

      if isinstance(screenWidget,wxTextCtrl):
        event.SetTimestamp(0)
        self.AddPendingEvent(event)

    else:
      textObject= wxPyTypeCast(object, 'wxTextCtrl')
      cursorPosition = textObject.GetInsertionPoint()
      self._eventProcessor('requestCURSORMOVE',position=cursorPosition,_form=gfObject._form)

    event.Skip()


#
# keyboardEvtHandler
#
# Traps most keypress events and translates them into
# GNUe events passed back to the form
#
# Note: wxEVT_KEY_DOWN event seems to only return uppercase chars so
#       i don't trap it.
#

class keyboardEvtHandler(uiBaseEvtHandler):
  def __init__(self, eventProcessor, uiDriver):
    eventList = [wxEVT_CHAR]
    uiBaseEvtHandler.__init__(self, eventList, eventProcessor, uiDriver)

  def _processEvent(self,event):

    action = None
    # hack for swig shortcomming needed by wxPython 2.2.x (2.3 does not need this)
    # compute the location of the character in the widget
    object = self._uiDriver._IdToGFObj[_eventObjTowxWindow(event).GetId()]

    keycode = event.KeyCode()
    #
    # Sigh... a hack for using <enter> in multiline entries
    #
    if  keycode == 13 and \
        not event.ShiftDown() and \
        not event.ControlDown() and \
        not event.AltDown() and \
        int (gConfigForms('enterIsNewLine')) and \
        (hasattr(object,'Char__height') and object.Char__height) > 1:

      command = 'NEWLINE'

    else:


      #
      # Get the event to process from the KeyMapper
      #
      command = GFKeyMapper.KeyMapper.getEvent(
        keycode,
        event.ShiftDown(),
        event.ControlDown(),
        event.AltDown())

    if command == 'JUMPRECORD':
      global _PROMPTFORRECORD
      action = _PROMPTFORRECORD()

    elif command == 'NEWLINE':
      action = events.Event('requestKEYPRESS', '\n',
                     text='\n',
                     code=10)

    elif command:
      action = events.Event('request%s' % command)

    elif object._type == 'GFButton':
      action = events.Event('buttonActivated',object)

    elif object.style == 'checkbox' and object._type == 'GFEntry':
      # <space> <=> <click>
      if keycode == 32:
          action = events.Event('requestTOGGLECHKBOX')
      else:
          # maybe some background error message here
          pass
    else:
      try:
        char = chr(keycode)
        if char in string.printable or char == "\n" or \
           128 <= keycode <= 255:
          action = events.Event('requestKEYPRESS', wxDecode(char),
                         text=wxDecode(char),
                         code=keycode)
      except ValueError:
        pass 

    if action:
      # Add the object's _form to the outgoing event
      # rather than every event in the function
      action.__dict__.update({'_form':object._form})
      self._eventProcessor(action)

                                                              
#####################################################################
##
## Keymapper Support
##
#####################################################################
from gnue.forms import GFKeyMapper
from gnue.forms.GFKeyMapper import vk

# Translate from wx keystrokes to our virtual keystrokes
wxKeyTranslations = {
    vk.C      : 3,             vk.V         : 22,
    vk.X      : 24,            vk.A         : 1,
    vk.F1     : WXK_F1,        vk.F2        : WXK_F2,
    vk.F3     : WXK_F3,        vk.F4        : WXK_F4,
    vk.F5     : WXK_F5,        vk.F6        : WXK_F6,
    vk.F7     : WXK_F7,        vk.F8        : WXK_F8,
    vk.F9     : WXK_F9,        vk.F10       : WXK_F10,
    vk.F11    : WXK_F11,       vk.F12       : WXK_F12,
    vk.INSERT : WXK_INSERT,    vk.DELETE    : WXK_DELETE,
    vk.HOME   : WXK_HOME,      vk.END       : WXK_END,
    vk.PAGEUP : WXK_PRIOR,     vk.PAGEDOWN  : WXK_NEXT,
    vk.UP     : WXK_UP,        vk.DOWN      : WXK_DOWN,
    vk.LEFT   : WXK_LEFT,      vk.RIGHT     : WXK_RIGHT,
    vk.TAB    : WXK_TAB,
    vk.ENTER  : WXK_RETURN,    vk.BACKSPACE : WXK_BACK }

GFKeyMapper.KeyMapper.setUIKeyMap(wxKeyTranslations)

      
