#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from wxPython.wx import *

from gnue.common import events
from gnue.forms.uidrivers.wx.common import _setDefaultEventHandlers
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow, wxEncode
from gnue.forms.uidrivers.wx.widgets._base import UIHelper

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    newWidget = wxButton(event.container,-1,wxEncode(object.label),
                         wxPoint(object.Char__x*event.widgetWidth,(object.Char__y+spacer)*event.widgetHeight),
                         wxSize(object.Char__width*event.widgetWidth,object.Char__height*event.widgetHeight)
                         )
    if event.initialize:
      self._eventHandler = event.eventHandler
      EVT_BUTTON(newWidget,newWidget.GetId(),self.buttonHandler)
      _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize, self._uiDriver)

    return newWidget

  def buttonHandler(self,event):
    if event.GetEventType() == wxEVT_COMMAND_BUTTON_CLICKED:
      action = None
      object = _eventObjTowxWindow(event)
      id = object.GetId()
      gfObject     = self._uiDriver._IdToGFObj[id]
      action = events.Event('buttonActivated',gfObject)
      self._eventHandler(action)

configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
