#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from wxPython.wx import *

from wxPython.wx import *
from gnue.common import events

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow
from gnue.forms.uidrivers.wx.common import _setDefaultEventHandlers


#
# UIScrollBar
#
# Widget set specific function that creates a single instance of a scroll bar used
# to navigate multiple records
#
class UIScrollBar(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    newWidget = self._widget = wxScrollBar(event.container,-1,
                           wxPoint(object.Char__x*event.widgetWidth,(object.Char__y+spacer)*event.widgetHeight),
                           wxSize(object.Char__width*event.widgetWidth,object.Char__height*event.widgetHeight),
                           wxSB_VERTICAL)

    if event.initialize:
      self._eventHandler = event.eventHandler
      EVT_COMMAND_SCROLL(newWidget, newWidget.GetId(), self.scrollbarHandler)
      _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize,self._uiDriver)

      object._block.registerScrollbar(self)
      self._rows = object._block._rows

    return newWidget

  def scrollbarHandler(self, event):
    object = _eventObjTowxWindow(event)
    id = object.GetId()

    value = object.GetThumbPosition()
    recno = int(value)+1

    gfObject     = self._uiDriver._IdToGFObj[id]
    action = events.Event('requestRECORDNUMBER',object=gfObject,
                            data=recno,
                          _form=gfObject._form)
    self._eventHandler(action)

  def adjustScrollbar(self, pos, range):
      # position, thumbSize, range, pageSize, refresh = TRUE
      self._widget.SetScrollbar(pos, self._rows, range+self._rows-1, self._rows-1)

configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
