#
# Copyright 2002-2003 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# UItext.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via line-mode
# text.
#
# NOTES:
# This file is nothing but a temporary hack.  Navigator should
# reuse GNUe Form's UI* classes if at all possible.

import string, sys

class Instance:
  def __init__(self, processes):
    self.processes = processes

  def run(self, connections):
    print "Login Handler set"
    
    connections.setLoginHandler(LoginHandler())
    self.buildMenu(self.processes)
    
    self.connections = connections
    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.connections.setLoginHandler(ui.UILoginHandler())

  def buildMenu(self, process):

    while 1:
      self.selections = {}
      count = 0
      maxSize = 0

      print "\n"

      title = process._type == 'GNProcesses' and process.title or \
                        process.title

      print "*" * len(title)
      print title
      print "*" * len(title)
      print

      for child in process._children:

        if child._type != 'GNDescription':        
          
          count += 1
          
          if child._type == 'GNProcess':
            text = "%s >" % (child.title)
          elif child._type == 'GNStep':
            text = child.title
          else:
            text = 'unknown type %s' % child._type
            
          self.selections["%s" % count] = child
          print "%3d: %s" % (count, text)


      print

      if process._parent:

        top = process._parent
        while top._parent:
          top = top._parent

        if top != process._parent:
          print '  P: Back to %s'% process._parent.title
          self.selections['P'] = process._parent

        print "  T: Back to Top"
        self.selections['T'] = top

      print "  Q: Quit"


      selection = getInput ("Selection: ", None, self.selections.keys() + ['Q'])

      if selection == 'Q':
        sys.exit()

      object = self.selections[selection]
      if object._type == 'GNStep':
        object.run()
      else:
        process = object

  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  def beginWait (self):
    pass

  # Called whenever forms leaves a "wait" state
  def endWait (self):
    pass




def getInput(message, default, responseSet=None):
  print ""
  while 1:
    if default != None:
      print "%s [%s] " % (message, default),
    else:
      print "%s " % (message),

    val = string.strip(sys.stdin.readline())
    print ""

    if not len(val) and default != None:
      return default
    elif responseSet and string.upper(val) in (responseSet):
      return string.upper(val)
    elif not responseSet:
      return val


from gnue.common.datasources import GLoginHandler
import getpass
class LoginHandler(GLoginHandler.LoginHandler):

  defaults = {'_username': None, '_password': None}

  def getLogin(self, loginData, error):
    try:
      print ( "*"*60 )
      if len(loginData[1]):
        print ( 'Attempting to log into "%s" (%s):' % (loginData[1], loginData[0]) )
      else:
        print ( 'Attempting to log into %s:' % (loginData[0]) )
      print ("")
      val = {}
      for prompt in loginData[2]:
         if self.defaults.has_key(prompt[0])  and self.defaults[prompt[0]]:
           print_nl ( "  %s: " % prompt[1] )
           if prompt[2]:
             print ( "***" )
           else:
             print ( self.defaults[prompt[0]] )
           val[prompt[0]] = self.defaults[prompt[0]]
         else:
           if prompt[2]:
             val[prompt[0]] = getpass.getpass("  %s: " % prompt[1])
           else:
             val[prompt[0]] = raw_input("  %s: " % prompt[1])
      print ("")
      print ("*"*60)
      return val
    except KeyboardInterrupt:
      raise GLoginHandler.UserCanceledLogin


  def destroyLoginDialog(self):
    pass

