#
# Copyright 2002-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# kde-menu.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via line-mode
# text.
#
# NOTES:
# Optional parameters:
#   system[="/path/to/kdedir]   -- Install system-wide (needs root access)
#
#   menu="Menu/Structure"       -- Menu structure... by default,
#                                  "GNUe Apps/" + the to process's description
#   quiet                       -- Turn on quiet mode
#

import string, sys, os


def run(processes, args):

  print "Creating KDE2 menu structure.."

  arguments = {}
  for argument in args:
    if '=' in argument:
      param, value = string.split(argument,'=',1)
    else:
      param, value = (argument, "")

  directory = "~/.kde/share/applnk"

  if arguments.has_key('menu'):
    directory = os.path.join(directory,arguments['menu'])
  else:
    directory = os.path.join(directory,'GNUe Apps')

  directory = os.path.expanduser(directory)

  buildMenu(processes, directory)



def buildMenu(process, location):

  description = process._type == 'GNProcesses' and \
         process.title or process.description
  directory = os.path.join(location, string.replace(description,'/',''))

  if not os.path.exists(directory):
    os.makedirs(directory)

  outfile = open(os.path.join(directory,'.directory'),'w')
  outfile.write('[Desktop Entry]\nIcon=package\nName=%s\n' % description)

  for child in process._children:

    if child._type == 'GNStep':
      makeLinkFile(directory, child)
    else:
      buildMenu(child, directory)


def makeLinkFile(directory, step):

  outfile=open(os.path.join(
      directory,string.replace(step.description,"/","") + \
      '.desktop'),'w')

  if step.type == 'form':
    command = gConfig("RunFormCommand")
    icon = "konsole"
  elif step.type == 'report':
    command = gConfig("RunReportCommand")
    icon = "klpq"

  outfile.write("""\
[Desktop Entry]
Comment=%(description)s
Exec=%(executable)s %(location)s
Icon=%(icon)s
Name=%(description)s
Path=
Terminal=0
TerminalOptions=
Type=Application
X-KDE-SubstituteUID=false
X-KDE-Username=
""" % { 'executable': command,
        'icon': icon,
        'description': step.description,
        'location': step.location })

  outfile.close()



