#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GRRunUI.py
#
# DESCRIPTION:
# Utilities that present a UI to the reader
#
# NOTES:
#


from StringIO import StringIO
from gnue.common.utils.FileUtils import dyn_import

class GRRunUI:

  def __init__(self, client, reportInfo,ui='text',
               userParameters={},destination='-',
               destinationType='file',filter='raw',
               sortoption=None):


    self.client = client

    if ui != 'text':
      try:
        self.uimodule = dyn_import('gnue.forms.uidrivers.%s' % ui)

        # Nasty hackery
        from gnue.forms.GFConfig import ConfigOptions as FormConfigOptions
        client.configurationManager.loadApplicationConfig(section="forms",defaults=FormConfigOptions)
        client.configurationManager.registerAlias('gConfigForms', 'forms')

      except ImportError:
        ui = 'text'


    if ui == 'text':
      self.uimodule = None
      self.loginhandler = LoginHandler()
    else:
      self.loginhandler = self.uimodule.UILoginHandler()

    self.reportInfo = reportInfo
    self.userParameters = userParameters
    self.ui = ui
    self.destination = destination
    self.destinationType = destinationType
    self.filter = filter
    self.sortoption = sortoption


  def getLoginHandler(self):
    return self.loginhandler


  def run(self):
    if self.uimodule:
      pass


  def getParameters(self):
    return self.userParameters


  def getDestination(self):
    return self.destination


  def getDestinationType(self):
    return self.destinationType


  def getFilter(self):
    return self.filter


  def getSortOption(self):
    return self.sortoption




def buildForm(reportParameters, userParameters):
  buffer = StringIO()




#
# This is a (temporary?) solution to getting a login
#
from gnue.common.datasources import GLoginHandler

try:
  import getpass
except:
  getpass = None

class LoginHandler(GLoginHandler.LoginHandler):

  defaults = {'_username': None, '_password': None}

  def getLogin(self, loginData, error):
    try:
      from GRRun import quietprint, quietprint_nl
      quietprint ( "*"*60 )
      if len(loginData[1]):
        quietprint ( 'Attempting to log into "%s" (%s):' % (loginData[1], loginData[0]) )
      else:
        quietprint ( 'Attempting to log into %s:' % (loginData[0]) )
      quietprint ("")
      val = {}
      for prompt in loginData[2]:
         if self.defaults.has_key(prompt[0])  and self.defaults[prompt[0]]:
           quietprint_nl ( "  %s: " % prompt[1] )
           if prompt[2]:
             quietprint ( "***" )
           else:
             quietprint ( self.defaults[prompt[0]] )
           val[prompt[0]] = self.defaults[prompt[0]]
         else:
           if prompt[2] and getpass:
             val[prompt[0]] = getpass.getpass("  %s: " % prompt[1])
           else:
             val[prompt[0]] = raw_input("  %s: " % prompt[1])
      quietprint ("")
      quietprint ("*"*60)
      return val
    except KeyboardInterrupt:
      raise GLoginHandler.UserCanceledLogin


  def destroyLoginDialog(self):
    pass
