#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# FILE:
# Adapter.py
#
# DESCRIPTION:
# Class that contains the base filter adapter for GNUe Reports'
# "Universal" markup.
#
# NOTES:
#

from gnue.reports.base.GROutputAdapter import TransformAdapter as Base
from Parser import loadFile

class UniversalError(Exception):
  pass

class TransformAdapter(Base):
  def open(self):
    # We need a temp file
    self.input, self.infile = self.createTempFile()
    return self.input

  def close(self):

    # We are finished with the intermediate file, so
    # close in order for sablotron to be able to open it.
    self.input.close()

    if not hasattr(self,'writer'):
      raise 'No writer object defined! Please define a default.'

    # Get a file for output from the destination adapter.
    self.writer.outfile = self.destination.getOutputHandle()

    # Get the name of the transform script
    #try:
    #  module = formatters.loadFormatter(self.parameters['formatter'])
    #except KeyError:
    #  raise "Filter configuration file is missing the 'formatter=' parameter"
    print "load file"

    report = loadFile(self.infile)
    print "writer started"
    self.parse(report)
    
    infile.close()

    try:
      mimetype = self.parameters['mimetype']
    except:
      mimetype = self.MIMETYPE


    # Let the destination adapter do its thing
    self.destination.close(mimetype=mimetype)

    # clean up our temp files
    self.deleteTempFile(self.infile)


  def parse(self, report):
    self.writer.initialize()
    
    self.writer.finalize()
