#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# fax/hylafax.py
#
# DESCRIPTION:
# Basic destination adapter for writing to HylaFax's sendfax command
#
# NOTES:
#


from gnue.reports import VERSION
from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base
import sys, os, string


class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.usingHandle = 1
    self.input, self.tempfile = self.createTempFile()
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.usingHandle = 0
    self.input, self.tempfile = self.createTempFile()
    self.input.close()
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):

    if self.usingHandle:
      self.input.close()

    file = self.tempfile

    fax_to = string.replace(string.replace(self.destination, "`",""),';','')

    os.system('echo ' + gConfig('HylafaxCommand')% (fax_to) +" "  + file)
    self.deleteTempFile(self.tempfile)


# The supported mime types that can be fed to HylaFax
_supportedMimeTypes = ('plain/text', 'application/ps')
