#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# transforms/file/stdio.py
#
# DESCRIPTION:
# Basic destination adapter for writing to stdout
#
# NOTES:
#

import sys

from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base

class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.tempfile = None
    self.input = sys.stdout

    # Make any output from the program go to stderr instead
    sys.stdout = sys.stderr
    
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    input, self.tempfile = self.createTempFile()
    input.close()
    
    # Make any output from the program go to stderr instead
    self.input = sys.stdout
    sys.stdout = sys.stderr
    
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):
    #
    # If we had to use a temp file, echo it back to screen
    #
    if self.tempfile:
      input = open(self.tempfile)
      self.input.write(input.read())
      input.close()
      self.deleteTempFile(self.tempfile)

