#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2004 Free Software Foundation
#
# $Id: PrinterDefs.py 6764 2004-12-01 00:34:26Z jcater $
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.common.formatting.GTypecast import escaped
from gnue.common.apps import GConfig
import os.path


location = GConfig.getInstalledBase('reports_shared','common_shared','install_prefix')

class PrinterDefinition:
  def __init__(self, definition): 
    
    f = open(os.path.join(location,'filters','Char',"%s.grp" % definition))
    
    self._values = values = {}
    self._escapes = escapes = {}
    for line in f.readlines(): 
      line = line[:-1].lstrip()
      if not line or line[0] == '#': 
        continue
      try:
        name,value = line.split('=',1)
      except:
        continue
      if name[-1:] == '+': 
        name = name[:-1]
        appending = True
      else: 
        appending = False
      name = name.strip().lower()
      if not name or not value: continue
      value = escaped(value)
      if name == 'escape_map': 
        # Special case
        escapes[value[0]] = value[1:]
      else:      
        if appending: 
          values[name] = values.get(name,"") + value
        else:
          values[name] = value

  def __getitem__(self, key):
    return self._values.get(key,'')
    
  def escape(self, value): 
    value = (value or '')
    for char, replace in self._escapes.items(): 
      value = value.replace(char, replace)
    return value

      
if __name__ == '__main__': 
  import sys
  p = PrinterDefinition('../etc/printdef/%s.grp' % (sys.argv[1:2][0] or 'escp'))
  print repr(p.escape('(\\Test)'))
  
  