#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2005 Free Software Foundation
#
# FILE:
# rtf/Writer.py
#
# DESCRIPTION:
#
# NOTES:
# * RTF 1.4 http://www.logictran.com/RTF/RTF114.htm
# * RTF 1.5 http://www.biblioscape.com/rtf15_spec.htm
# * RTF 1.6 http://msdn.microsoft.com/library/en-us/dnrtfspec/html/rtfspec.asp
# If 1.3 compatability can be maintained, it is preferred

__all__ = ['Writer']

from gnue.reports.adapters.filters.Universal.Base.Writers.RelativeWriter import *

class Writer(RelativeWriter):

  # Supported features
  BITMAP_FORMATS=[]


  def initialize(self):
    # Write headers to file... initialize state variables
    self.output.write("""{\rtf0\ansi
{\fonttbl
{\f0\froman\fcharset0\fprq2 Times New Roman;}
{\f1\froman\fcharset0\fprq2 Times New Roman;}
{\f2\froman\fcharset0\fprq2 Times New Roman;}
{\f3\fswiss\fcharset0\fprq2 Arial;}
{\f4\froman\fcharset2\fprq2 Symbol;}
{\f5\fmodern\fcharset0 Courier New;}
{\f6\fnil\fcharset2\fprq2 Wingdings;}
{\f7\fswiss\fcharset0\fprq2 Helvetica;}
{\f8\froman Times;}}
""")


  def finalize(self):
    # Write any footers to file
    self.output.write("}\n")


