#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRExceptions.py
#
# DESCRIPTION:
# Contains all exceptions that can be thrown by 
#
# NOTES:
#
# HISTORY:
#


############################################################
#
#  All exceptions in this file descend from ReportException
#
class ReportException(StandardError): 
  pass


############################################################
#
# Raised if unable to read the report definition
#
class ReportUnreadable(ReportException): 
  pass


############################################################
#
#  All exceptions related to an invalid report definition 
#  descend from ReportException
#
class ReportMarkupException(ReportException): 
  pass

# Raised if report definition does not contain any layout directives
class NoLayoutDefined(ReportMarkupException):
  pass

# Raised if report definition does not contain a <layout> section
class NoLayoutSection(NoLayoutDefined):
  pass

# Raised if report definition does not contain a <sources> section
class NoSourcesSection(ReportMarkupException): 
  pass

# Raised if a datasource references a master that does not exist
class MasterSourceNotFound(ReportMarkupException): 
  pass

# Raised if a source is referenced in  sibling sections. 
# Sources can only be mapped to a single section or children 
# of that section.
class SourceMappedToSiblingSections(ReportMarkupException): 
  pass

# Raised if more than one section has the same name
class SectionHasDuplicateName(ReportMarkupException):
  pass

# Raised if a field is referenced without a source 
# and non of its ancestors define a source
class LayoutFieldHasNoSource(ReportMarkupException): 
  pass

# Raised if a summary is referenced without a source 
# and non of its ancestors define a source
class LayoutSummaryHasNoSource(ReportMarkupException): 
  pass

# Raised if a field/summary uses a source outside of its scope 
class SourceOutOfScope(ReportMarkupException): 
  pass

# Raised if a the connection specified doesn't exist in a connections.conf file
class ConnectionUndefined(ReportMarkupException): 
  pass

