#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.definitions.GObjects import *
from gnue.common.apps import GDebug
from gnue.common.datasources import GConditions
from gnue.common.logic.GTrigger import GTrigger,GTriggerExtension

import string
from xml.sax import saxutils


############################################################
#
# Any elements contained within a <layout> element
# inherit GRLayoutElement
#
class GRLayoutElement (GObj, GTriggerExtension):
  def __init__(self, parent=None, type='GRLayoutElement'):
    GTriggerExtension.__init__(self)
    GObj.__init__(self, parent, type=type)
    self.name = "__%s__" % self
    self._source = None
    self._mymapper = None
    self._enabled = 1
    self._process = self.process
    self._triggerFunctions = {'enable':{'function':self.enable } }

  # Called if section contains data...
  # (The namespace-qualified version)
  def __processWithNamespace(self, dest, *args, **parms):
    
    if not self._enabled: return 
    
    tag = self.getXmlTag()
    attrs = ""
    for attr in self.__dict__.keys():
      try:    prefix, att = attr.split('__',1)
      except: continue

      if prefix in self._xmlnamespaces.keys():
        attrs += ' %s="%s"' % (att, saxutils.escape(self.__dict__[attr]))

    dest.write('<%s%s>' % (tag, attrs))
    rv = self.process(dest, *args, **parms)
    dest.write('</%s>' % tag)

    return rv
          
    
  def process(self, dest, mapper, isfirst, islast, firstSection, nextSection):
    return nextSection

    
  def prepare(self):
    if hasattr(self,'source') and self.source is not None:
      self._source = self.source
    else:
      try:
        self._source = self.getParent ()._source
      except AttributeError:
        self._source = None

    # Avoid any overhead if this element doesn't
    # contain namespace-qualified attributes
    if self._xmlnamespaces:
      self._process = self.__processWithNamespace
    else: 
      self._process = self.process
      
    return GObj._buildObject(self)


  def enable(self, value=1): 
    self._enabled = value
    
